/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client.lua;

import com.aerospike.client.Log;
import com.aerospike.client.lua.LuaStream;
import com.aerospike.client.query.ResultSet;
import org.luaj.vm2.LuaString;
import org.luaj.vm2.LuaUserdata;
import org.luaj.vm2.LuaValue;

public final class LuaOutputStream
extends LuaUserdata
implements LuaStream {
    private final ResultSet resultSet;

    public LuaOutputStream(ResultSet resultSet) {
        super((Object)resultSet);
        this.resultSet = resultSet;
    }

    @Override
    public LuaValue read() {
        throw new RuntimeException("LuaOutputStream is not readable.");
    }

    @Override
    public void write(LuaValue source) {
        Object target;
        switch (source.type()) {
            case 3: {
                if (source.isint()) {
                    target = source.toint();
                    break;
                }
                target = source.tolong();
                break;
            }
            case 1: {
                target = source.toboolean();
                break;
            }
            case 4: {
                target = source.toString();
                break;
            }
            case 7: {
                LuaUserdata data = (LuaUserdata)source;
                target = data.m_instance;
                break;
            }
            default: {
                if (Log.warnEnabled()) {
                    Log.warn("Invalid lua type: " + source.type());
                }
                target = ResultSet.END;
            }
        }
        this.resultSet.put(target);
    }

    @Override
    public boolean readable() {
        return false;
    }

    @Override
    public boolean writeable() {
        return true;
    }

    @Override
    public LuaValue toLuaString() {
        return LuaString.valueOf((String)LuaOutputStream.class.getName());
    }
}

