/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client.command;

import com.aerospike.client.AerospikeException;
import com.aerospike.client.util.MsgPack;
import java.io.ByteArrayInputStream;
import java.io.ObjectInputStream;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.util.Arrays;

public final class Buffer {
    public static Object bytesToParticle(int type, byte[] buf, int offset, int len2) throws AerospikeException {
        switch (type) {
            case 3: {
                return Buffer.utf8ToString(buf, offset, len2);
            }
            case 1: {
                return Buffer.bytesToNumber(buf, offset, len2);
            }
            case 4: {
                return Arrays.copyOfRange(buf, offset, offset + len2);
            }
            case 7: {
                return Buffer.bytesToObject(buf, offset, len2);
            }
            case 20: {
                return MsgPack.parseList(buf, offset, len2);
            }
            case 19: {
                return MsgPack.parseMap(buf, offset, len2);
            }
        }
        return null;
    }

    public static int estimateSizeUtf8(String value) {
        if (value == null) {
            return 0;
        }
        int max = value.length();
        int count = 0;
        for (int i = 0; i < max; ++i) {
            char ch = value.charAt(i);
            if (ch <= '\u007f') {
                ++count;
                continue;
            }
            if (ch <= '\u07ff') {
                count += 2;
                continue;
            }
            if (Character.isHighSurrogate(ch)) {
                count += 4;
                ++i;
                continue;
            }
            count += 3;
        }
        return count;
    }

    public static int stringToUtf8(String s, byte[] buf, int offset) {
        if (s == null) {
            return 0;
        }
        int length = s.length();
        int startOffset = offset;
        for (int i = 0; i < length; ++i) {
            char c = s.charAt(i);
            if (c < '\u007f') {
                buf[offset] = (byte)c;
                ++offset;
                continue;
            }
            if (c < '\u07ff') {
                buf[offset] = (byte)(0xC0 | c >> 6);
                buf[offset + 1] = (byte)(0x80 | c & 0x5F);
                offset += 2;
                continue;
            }
            try {
                byte[] value = s.getBytes("UTF8");
                System.arraycopy(value, 0, buf, startOffset, value.length);
                return value.length;
            }
            catch (UnsupportedEncodingException uee) {
                throw new RuntimeException("UTF8 encoding is not supported.");
            }
        }
        return offset - startOffset;
    }

    public static String utf8ToString(byte[] buf, int offset, int length) {
        char[] charBuffer = new char[length];
        int charCount = 0;
        int limit = offset + length;
        int origoffset = offset;
        while (offset < limit) {
            char c;
            if ((buf[offset] & 0x80) == 0) {
                c = (char)buf[offset];
                charBuffer[charCount++] = c;
                ++offset;
                continue;
            }
            if ((buf[offset] & 0xE0) == 192) {
                c = (char)((buf[offset] & 0x1F) << 6 | buf[offset + 1] & 0x3F);
                charBuffer[charCount++] = c;
                offset += 2;
                continue;
            }
            try {
                return new String(buf, origoffset, length, "UTF8");
            }
            catch (UnsupportedEncodingException uee) {
                throw new RuntimeException("UTF8 decoding is not supported.");
            }
        }
        return new String(charBuffer, 0, charCount);
    }

    public static String utf8ToString(byte[] buf, int offset, int length, StringBuilder sb) {
        sb.setLength(0);
        int limit = offset + length;
        int origoffset = offset;
        while (offset < limit) {
            char c;
            if ((buf[offset] & 0x80) == 0) {
                c = (char)buf[offset];
                sb.append(c);
                ++offset;
                continue;
            }
            if ((buf[offset] & 0xE0) == 192) {
                c = (char)((buf[offset] & 0x1F) << 6 | buf[offset + 1] & 0x3F);
                sb.append(c);
                offset += 2;
                continue;
            }
            try {
                return new String(buf, origoffset, length, "UTF8");
            }
            catch (UnsupportedEncodingException uee) {
                throw new RuntimeException("UTF8 decoding is not supported.");
            }
        }
        return sb.toString();
    }

    public static int utf8DigitsToInt(byte[] buf, int begin, int end) {
        int val = 0;
        int mult = 1;
        for (int i = end - 1; i >= begin; --i) {
            val += (buf[i] - 48) * mult;
            mult *= 10;
        }
        return val;
    }

    public static String bytesToHexString(byte[] buf) {
        StringBuilder sb = new StringBuilder(buf.length * 2);
        for (int i = 0; i < buf.length; ++i) {
            sb.append(String.format("%02x", buf[i]));
        }
        return sb.toString();
    }

    public static Object bytesToObject(byte[] buf, int offset, int length) throws AerospikeException.Serialize {
        try {
            ByteArrayInputStream bastream = new ByteArrayInputStream(buf, offset, length);
            ObjectInputStream oistream = new ObjectInputStream(bastream);
            return oistream.readObject();
        }
        catch (Exception e) {
            throw new AerospikeException.Serialize(e);
        }
    }

    public static Object bytesToNumber(byte[] buf, int offset, int len2) {
        if (len2 == 0) {
            return new Integer(0);
        }
        if (len2 > 8) {
            return Buffer.bytesToBigInteger(buf, offset, len2);
        }
        long val = 0L;
        for (int i = 0; i < len2; ++i) {
            val <<= 8;
            val |= (long)(buf[offset + i] & 0xFF);
        }
        if (val <= Integer.MAX_VALUE && val >= Integer.MIN_VALUE) {
            return new Integer((int)val);
        }
        return new Long(val);
    }

    public static Object bytesToBigInteger(byte[] buf, int offset, int len2) {
        boolean negative = false;
        if ((buf[offset] & 0x80) != 0) {
            negative = true;
            int n = offset;
            buf[n] = (byte)(buf[n] & 0x7F);
        }
        byte[] bytes = new byte[len2];
        System.arraycopy(buf, offset, bytes, 0, len2);
        BigInteger big = new BigInteger(bytes);
        if (negative) {
            big = big.negate();
        }
        return big;
    }

    public static void longToBytes(long v, byte[] buf, int offset) {
        for (int i = 7; i >= 0; --i) {
            buf[offset + i] = (byte)(v & 0xFFL);
            v >>>= 8;
        }
    }

    public static long bytesToLong(byte[] buf, int offset) {
        long a = 0L;
        for (int i = 0; i < 8; ++i) {
            a <<= 8;
            a |= (long)Buffer.getUnsigned(buf[offset + i]);
        }
        return a;
    }

    public static void intToBytes(int v, byte[] buf, int offset) {
        for (int i = 3; i >= 0; --i) {
            buf[offset + i] = (byte)(v & 0xFF);
            v >>>= 8;
        }
    }

    public static int bytesToInt(byte[] buf, int offset) {
        return (buf[offset] & 0xFF) << 24 | (buf[offset + 1] & 0xFF) << 16 | (buf[offset + 2] & 0xFF) << 8 | buf[offset + 3] & 0xFF;
    }

    public static int bytesToIntIntel(byte[] buf, int offset) {
        return (buf[offset + 3] & 0xFF) << 24 | (buf[offset + 2] & 0xFF) << 16 | (buf[offset + 1] & 0xFF) << 8 | buf[offset] & 0xFF;
    }

    public static void shortToBytes(int v, byte[] buf, int offset) {
        buf[offset] = (byte)(v >> 8 & 0xFF);
        buf[offset + 1] = (byte)(v & 0xFF);
    }

    public static int bytesToShort(byte[] buf, int offset) {
        return ((buf[offset] & 0xFF) << 8) + (buf[offset + 1] & 0xFF);
    }

    private static int getUnsigned(byte b) {
        int r = b;
        if (r < 0) {
            r &= 0x7F;
            r |= 0x80;
        }
        return r;
    }
}

