/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client.command;

import com.aerospike.client.AerospikeException;
import com.aerospike.client.Key;
import com.aerospike.client.Record;
import com.aerospike.client.cluster.Cluster;
import com.aerospike.client.command.BatchCommandExists;
import com.aerospike.client.command.BatchCommandGet;
import com.aerospike.client.command.BatchItem;
import com.aerospike.client.command.BatchNode;
import com.aerospike.client.command.MultiCommand;
import com.aerospike.client.policy.Policy;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;

public final class BatchExecutor
extends Thread {
    private final Policy policy;
    private final BatchNode batchNode;
    private final HashSet<String> binNames;
    private final HashMap<Key, BatchItem> keyMap;
    private final Record[] records;
    private final boolean[] existsArray;
    private final int readAttr;
    private Exception exception;

    public BatchExecutor(Policy policy, BatchNode batchNode, HashMap<Key, BatchItem> keyMap, HashSet<String> binNames, Record[] records, boolean[] existsArray, int readAttr) {
        this.policy = policy;
        this.batchNode = batchNode;
        this.keyMap = keyMap;
        this.binNames = binNames;
        this.records = records;
        this.existsArray = existsArray;
        this.readAttr = readAttr;
    }

    @Override
    public void run() {
        try {
            for (BatchNode.BatchNamespace batchNamespace : this.batchNode.batchNamespaces) {
                MultiCommand command;
                if (this.records != null) {
                    command = new BatchCommandGet(this.batchNode.node, this.keyMap, this.binNames, this.records);
                    command.setBatchGet(batchNamespace, this.binNames, this.readAttr);
                    command.execute(this.policy);
                    continue;
                }
                command = new BatchCommandExists(this.batchNode.node, this.keyMap, this.existsArray);
                command.setBatchExists(batchNamespace);
                command.execute(this.policy);
            }
        }
        catch (Exception e) {
            this.exception = e;
        }
    }

    public Exception getException() {
        return this.exception;
    }

    public static void executeBatch(Cluster cluster, Policy policy, Key[] keys2, boolean[] existsArray, Record[] records, HashSet<String> binNames, int readAttr) throws AerospikeException {
        HashMap<Key, BatchItem> keyMap = BatchItem.generateMap(keys2);
        List<BatchNode> batchNodes = BatchNode.generateList(cluster, keys2);
        ArrayList<BatchExecutor> threads = new ArrayList<BatchExecutor>(batchNodes.size());
        for (BatchNode batchNode : batchNodes) {
            BatchExecutor thread = new BatchExecutor(policy, batchNode, keyMap, binNames, records, existsArray, readAttr);
            threads.add(thread);
            thread.start();
        }
        for (BatchExecutor thread : threads) {
            try {
                thread.join();
            }
            catch (Exception e) {}
        }
        for (BatchExecutor thread : threads) {
            Exception e = thread.getException();
            if (e == null) continue;
            if (e instanceof AerospikeException) {
                throw (AerospikeException)e;
            }
            throw new AerospikeException(e);
        }
    }
}

