/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client.async;

import com.aerospike.client.AerospikeException;
import com.aerospike.client.async.AsyncCluster;
import com.aerospike.client.async.AsyncConnection;
import com.aerospike.client.cluster.Node;
import com.aerospike.client.cluster.NodeValidator;
import java.util.concurrent.ArrayBlockingQueue;

public final class AsyncNode
extends Node {
    private final ArrayBlockingQueue<AsyncConnection> asyncConnQueue;
    private final AsyncCluster cluster;

    public AsyncNode(AsyncCluster cluster, NodeValidator nv) {
        super(cluster, nv);
        this.cluster = cluster;
        this.asyncConnQueue = new ArrayBlockingQueue(cluster.getMaxCommands());
    }

    public AsyncConnection getAsyncConnection() throws AerospikeException.Connection {
        AsyncConnection conn;
        while ((conn = this.asyncConnQueue.poll()) != null) {
            if (conn.isValid()) {
                return conn;
            }
            conn.close();
        }
        return new AsyncConnection(this.address, this.cluster);
    }

    public void putAsyncConnection(AsyncConnection conn) {
        if (!this.active || !this.asyncConnQueue.offer(conn)) {
            conn.close();
        }
    }

    @Override
    protected void closeConnections() {
        AsyncConnection conn;
        super.closeConnections();
        while ((conn = this.asyncConnQueue.poll()) != null) {
            conn.close();
        }
    }
}

