/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client.async;

import com.aerospike.client.AerospikeException;
import com.aerospike.client.Log;
import com.aerospike.client.async.AsyncCluster;
import com.aerospike.client.async.AsyncConnection;
import com.aerospike.client.async.AsyncNode;
import com.aerospike.client.command.Command;
import com.aerospike.client.policy.Policy;
import com.aerospike.client.util.Util;
import java.io.IOException;
import java.nio.ByteBuffer;

public abstract class AsyncCommand
implements Runnable {
    protected AsyncConnection conn;
    protected ByteBuffer byteBuffer;
    protected final AsyncCluster cluster;
    protected AsyncNode node;
    private long limit;
    protected int timeout;
    private boolean complete;

    public AsyncCommand(AsyncCluster cluster) {
        this.cluster = cluster;
    }

    public void execute(Policy policy, Command command) throws AerospikeException {
        if (policy == null) {
            policy = new Policy();
        }
        this.timeout = policy.timeout;
        if (this.timeout > 0) {
            this.limit = System.currentTimeMillis() + (long)this.timeout;
        }
        this.byteBuffer = this.cluster.getByteBuffer();
        try {
            this.node = this.getNode();
            this.conn = this.node.getAsyncConnection();
            int size = command.getSendOffset();
            if (size > this.byteBuffer.capacity()) {
                this.byteBuffer = ByteBuffer.allocateDirect(size);
            }
            this.byteBuffer.clear();
            this.byteBuffer.put(command.getSendBuffer(), 0, size);
            this.byteBuffer.flip();
            this.conn.execute(this);
        }
        catch (AerospikeException.InvalidNode ai) {
            this.cluster.putByteBuffer(this.byteBuffer);
            throw ai;
        }
        catch (AerospikeException.Connection ce) {
            this.node.decreaseHealth();
            this.cluster.putByteBuffer(this.byteBuffer);
            throw ce;
        }
        catch (Exception e) {
            if (this.conn != null) {
                this.node.putAsyncConnection(this.conn);
            }
            this.cluster.putByteBuffer(this.byteBuffer);
            throw new AerospikeException(e);
        }
    }

    protected final void write() throws IOException {
        this.conn.write(this.byteBuffer);
    }

    protected final boolean checkTimeout() {
        if (this.complete) {
            return false;
        }
        long current = System.currentTimeMillis();
        if (this.limit > 0L && current > this.limit) {
            this.node.decreaseHealth();
            this.fail(new AerospikeException.Timeout());
            return false;
        }
        return true;
    }

    @Override
    public void run() {
        try {
            this.read();
            if (!this.complete) {
                this.conn.setReadable();
            }
        }
        catch (AerospikeException ae) {
            this.failCommand(ae);
        }
        catch (IOException ioe) {
            this.failCommand(ioe);
        }
        catch (Exception e) {
            this.failCommand(new AerospikeException(e));
        }
    }

    protected final void finish() {
        this.complete = true;
        this.conn.unregister();
        this.conn.updateLastUsed();
        this.node.putAsyncConnection(this.conn);
        this.node.restoreHealth();
        this.cluster.putByteBuffer(this.byteBuffer);
        this.onSuccess();
    }

    protected final void failConnection(AerospikeException ae) {
        if (Log.debugEnabled()) {
            Log.debug("Node " + this.node + ": " + Util.getErrorMessage(ae));
        }
        this.node.decreaseHealth();
        this.fail(ae);
    }

    protected final void failCommand(IOException ioe) {
        if (Log.debugEnabled()) {
            Log.debug("Node " + this.node + ": " + Util.getErrorMessage(ioe));
        }
        this.node.decreaseHealth();
        this.fail(new AerospikeException(ioe));
    }

    protected final void failCommand(AerospikeException ae) {
        if (Log.debugEnabled()) {
            Log.debug("Node " + this.node + ": " + Util.getErrorMessage(ae));
        }
        this.fail(ae);
    }

    private final void fail(AerospikeException ae) {
        this.complete = true;
        this.conn.close();
        this.cluster.putByteBuffer(this.byteBuffer);
        this.onFailure(ae);
    }

    protected abstract AsyncNode getNode() throws AerospikeException.InvalidNode;

    protected abstract void read() throws AerospikeException, IOException;

    protected abstract void onSuccess();

    protected abstract void onFailure(AerospikeException var1);
}

