/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client.async;

import com.aerospike.client.AerospikeException;
import com.aerospike.client.Host;
import com.aerospike.client.async.AsyncClientPolicy;
import com.aerospike.client.async.AsyncNode;
import com.aerospike.client.async.MaxCommandAction;
import com.aerospike.client.async.SelectorManager;
import com.aerospike.client.async.SelectorManagers;
import com.aerospike.client.cluster.Cluster;
import com.aerospike.client.cluster.Node;
import com.aerospike.client.cluster.NodeValidator;
import java.nio.ByteBuffer;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.atomic.AtomicInteger;

public final class AsyncCluster
extends Cluster {
    private final ArrayBlockingQueue<ByteBuffer> bufferQueue;
    private final SelectorManagers selectorManagers;
    private final MaxCommandAction maxCommandAction;
    private final AtomicInteger commandsUsed;
    private final int maxCommands;

    public AsyncCluster(AsyncClientPolicy policy, Host[] hosts) throws AerospikeException {
        super(policy, hosts);
        this.maxCommandAction = policy.asyncMaxCommandAction;
        this.maxCommands = policy.asyncMaxCommands;
        this.commandsUsed = new AtomicInteger();
        this.bufferQueue = new ArrayBlockingQueue(policy.asyncMaxCommands);
        this.selectorManagers = new SelectorManagers(policy);
        this.initTendThread();
    }

    @Override
    protected Node createNode(NodeValidator nv) {
        return new AsyncNode(this, nv);
    }

    public ByteBuffer getByteBuffer() throws AerospikeException {
        if (this.commandsUsed.incrementAndGet() <= this.maxCommands || this.maxCommandAction == MaxCommandAction.ACCEPT) {
            ByteBuffer byteBuffer = this.bufferQueue.poll();
            if (byteBuffer != null) {
                return byteBuffer;
            }
            return ByteBuffer.allocateDirect(8192);
        }
        if (this.maxCommandAction == MaxCommandAction.REJECT) {
            this.commandsUsed.decrementAndGet();
            throw new AerospikeException.CommandRejected();
        }
        try {
            return this.bufferQueue.take();
        }
        catch (InterruptedException ie) {
            this.commandsUsed.decrementAndGet();
            throw new AerospikeException("Buffer pool take interrupted.");
        }
    }

    public void putByteBuffer(ByteBuffer byteBuffer) {
        this.commandsUsed.decrementAndGet();
        this.bufferQueue.offer(byteBuffer);
    }

    public SelectorManager getSelectorManager() {
        return this.selectorManagers.next();
    }

    public int getMaxCommands() {
        return this.maxCommands;
    }

    @Override
    public void close() {
        super.close();
        this.selectorManagers.close();
    }
}

