/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client;

import com.aerospike.client.ResultCode;

public class AerospikeException
extends Exception {
    private static final long serialVersionUID = 1L;
    private int resultCode;

    public AerospikeException(int resultCode, String message) {
        super(message);
        this.resultCode = resultCode;
    }

    public AerospikeException(int resultCode, Exception e) {
        super(e);
        this.resultCode = resultCode;
    }

    public AerospikeException(int resultCode) {
        this.resultCode = resultCode;
    }

    public AerospikeException(String message, Exception e) {
        super(message, e);
    }

    public AerospikeException(String message) {
        super(message);
    }

    public AerospikeException(Exception e) {
        super(e);
    }

    public AerospikeException() {
    }

    @Override
    public String getMessage() {
        StringBuilder sb = new StringBuilder();
        String message = super.getMessage();
        if (this.resultCode != 0) {
            sb.append("Error Code ");
            sb.append(this.resultCode);
            sb.append(": ");
            if (message != null) {
                sb.append(message);
            } else {
                sb.append(ResultCode.getResultString(this.resultCode));
            }
        } else if (message != null) {
            sb.append(message);
        } else {
            sb.append(this.getClass().getName());
        }
        return sb.toString();
    }

    public final int getResultCode() {
        return this.resultCode;
    }

    public static final class CommandRejected
    extends AerospikeException {
        private static final long serialVersionUID = 1L;

        public CommandRejected() {
            super(-6);
        }
    }

    public static final class QueryTerminated
    extends AerospikeException {
        private static final long serialVersionUID = 1L;

        public QueryTerminated() {
            super(-5);
        }

        public QueryTerminated(Exception e) {
            super(-5, e);
        }
    }

    public static final class ScanTerminated
    extends AerospikeException {
        private static final long serialVersionUID = 1L;

        public ScanTerminated() {
            super(-4);
        }

        public ScanTerminated(Exception e) {
            super(-4, e);
        }
    }

    public static final class InvalidNode
    extends AerospikeException {
        private static final long serialVersionUID = 1L;

        public InvalidNode() {
            super(-3);
        }
    }

    public static final class Connection
    extends AerospikeException {
        private static final long serialVersionUID = 1L;

        public Connection(String message) {
            super(11, message);
        }

        public Connection(Exception e) {
            super(11, e);
        }
    }

    public static final class Parse
    extends AerospikeException {
        private static final long serialVersionUID = 1L;

        public Parse(String message) {
            super(-2, message);
        }
    }

    public static final class Serialize
    extends AerospikeException {
        private static final long serialVersionUID = 1L;

        public Serialize(Exception e) {
            super(-1, e);
        }
    }

    public static final class Timeout
    extends AerospikeException {
        private static final long serialVersionUID = 1L;

        public Timeout() {
            super(9);
        }
    }
}

