/*
 * Decompiled with CFR 0.152.
 */
package flex.rds.server.servlet.internal;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Map;
import org.w3c.dom.Document;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavatoFiberTypeMap {
    private static String defaultType = "opaque";
    private static Map<String, String> typeMap = new HashMap<String, String>();

    public static String get(String key) {
        String type = typeMap.get(key);
        if (type == null) {
            return defaultType;
        }
        return type;
    }

    public static boolean contains(String CFType) {
        return typeMap.containsKey(CFType);
    }

    private static void addTypemapping(String name, String str) {
        typeMap.put(name, str);
    }

    public static boolean isJavaMap(Class<?> class1) {
        return Map.class.isAssignableFrom(class1);
    }

    public static boolean isJavaCollection(Class<?> class1) {
        return Collection.class.isAssignableFrom(class1);
    }

    public static boolean isJavaEnum(Class<?> class1) {
        return Enum.class.isAssignableFrom(class1);
    }

    public static boolean isJavaBigDecimal(Class<?> class1) {
        return BigDecimal.class.isAssignableFrom(class1);
    }

    public static boolean isJavaBigInteger(Class<?> class1) {
        return BigInteger.class.isAssignableFrom(class1);
    }

    public static boolean isJavaDictionary(Class<?> class1) {
        return Dictionary.class.isAssignableFrom(class1);
    }

    public static boolean isJavaDocument(Class<?> class1) {
        return Document.class.isAssignableFrom(class1);
    }

    static {
        JavatoFiberTypeMap.addTypemapping(Object.class.getCanonicalName(), "opaque");
        JavatoFiberTypeMap.addTypemapping(String.class.getCanonicalName(), "string");
        JavatoFiberTypeMap.addTypemapping(Integer.class.getCanonicalName(), "integer");
        JavatoFiberTypeMap.addTypemapping(Boolean.class.getCanonicalName(), "boolean");
        JavatoFiberTypeMap.addTypemapping(Float.class.getCanonicalName(), "float");
        JavatoFiberTypeMap.addTypemapping(Double.class.getCanonicalName(), "double");
        JavatoFiberTypeMap.addTypemapping(Long.class.getCanonicalName(), "long");
        JavatoFiberTypeMap.addTypemapping(Character.class.getCanonicalName(), "char");
        JavatoFiberTypeMap.addTypemapping(Byte.class.getCanonicalName(), "integer");
        JavatoFiberTypeMap.addTypemapping(Date.class.getCanonicalName(), "date");
        JavatoFiberTypeMap.addTypemapping(Calendar.class.getCanonicalName(), "date");
        JavatoFiberTypeMap.addTypemapping(Short.class.getCanonicalName(), "integer");
        JavatoFiberTypeMap.addTypemapping(Integer.TYPE.getCanonicalName(), "integer");
        JavatoFiberTypeMap.addTypemapping(Boolean.TYPE.getCanonicalName(), "boolean");
        JavatoFiberTypeMap.addTypemapping(Float.TYPE.getCanonicalName(), "float");
        JavatoFiberTypeMap.addTypemapping(Double.TYPE.getCanonicalName(), "double");
        JavatoFiberTypeMap.addTypemapping(Long.TYPE.getCanonicalName(), "long");
        JavatoFiberTypeMap.addTypemapping(Character.TYPE.getCanonicalName(), "char");
        JavatoFiberTypeMap.addTypemapping(Byte.TYPE.getCanonicalName(), "integer");
        JavatoFiberTypeMap.addTypemapping(Void.TYPE.getCanonicalName(), "void");
        JavatoFiberTypeMap.addTypemapping(Short.TYPE.getCanonicalName(), "integer");
        JavatoFiberTypeMap.addTypemapping(byte[].class.getCanonicalName(), "blob");
        JavatoFiberTypeMap.addTypemapping(Byte[].class.getCanonicalName(), "blob");
    }
}

