/*
 * Decompiled with CFR 0.152.
 */
package flex.rds.server;

import flex.messaging.MessageBroker;
import flex.messaging.security.LoginCommand;
import flex.messaging.security.LoginManager;
import flex.rds.server.RdsRequest;
import flex.rds.server.RdsRequestImpl;
import flex.rds.server.RdsResponse;
import flex.rds.server.RdsResponseImpl;
import flex.rds.server.util.Encryptor;
import flex.rds.server.util.RB;
import java.io.IOException;
import java.security.Principal;
import java.util.List;
import java.util.Vector;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public abstract class RdsServlet
extends HttpServlet {
    private List<String> rdsRoles;
    private MessageBroker messageBroker;
    private boolean useSecurityModel;

    public void init(ServletConfig config) throws ServletException {
        String messageBrokerID = config.getInitParameter("messageBrokerId");
        this.messageBroker = MessageBroker.getMessageBroker((String)messageBrokerID);
        if (this.messageBroker == null) {
            throw new ServletException(RB.getString((Object)this, "RdsServlet.MissingMessageBroker"));
        }
        super.init(config);
        this.useSecurityModel = true;
        String initParam = config.getInitParameter("useAppserverSecurity");
        if ("false".equalsIgnoreCase(initParam)) {
            this.useSecurityModel = false;
        }
        this.rdsRoles = new Vector<String>();
        this.rdsRoles.add("rds");
    }

    protected MessageBroker getMessageBroker() {
        return this.messageBroker;
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        HttpServletResponse resp;
        HttpServletRequest req;
        try {
            req = request;
            resp = response;
        }
        catch (ClassCastException e) {
            throw new ServletException(RB.getString((Object)this, "RdsServlet.NonHttp"));
        }
        RdsRequestImpl rdsReq = new RdsRequestImpl();
        RdsResponseImpl rdsResp = new RdsResponseImpl();
        rdsReq.init(req);
        rdsResp.init(resp);
        try {
            if (this.isSecure() && !this.checkAuthorization(rdsReq.getUserName(), rdsReq.getPassword())) {
                String errorMsg = RB.getString((Object)this, "RdsServlet.AccessDenied");
                this.log(errorMsg);
                rdsResp.setError(-100, errorMsg, null);
                rdsResp.addMetaData("0");
            } else {
                this.processCmd(rdsReq, rdsResp);
            }
        }
        catch (Throwable th) {
            this.log(th.getMessage(), th);
            rdsResp.setError(th);
        }
        this.doPostProcessCmd(rdsReq, rdsResp);
    }

    protected abstract void processCmd(RdsRequest var1, RdsResponse var2) throws ServletException, IOException;

    private void doPostProcessCmd(RdsRequestImpl request, RdsResponseImpl response) throws IOException, ServletException {
        response.finish();
        request.reset();
        response.reset();
    }

    public boolean checkAuthorization(String username, String password) {
        return this.checkUsernamePassword(username, password);
    }

    protected boolean checkMessageBrokerAuthentication(String username, String password) {
        if (!this.useSecurityModel) {
            return true;
        }
        try {
            LoginManager lm = this.getMessageBroker().getLoginManager();
            LoginCommand lc = lm.getLoginCommand();
            if (lc == null) {
                return false;
            }
            Principal p = lm.getLoginCommand().doAuthentication(username, (Object)password);
            if (p == null) {
                return false;
            }
            return lm.checkRoles(p, this.rdsRoles);
        }
        catch (Throwable t) {
            return false;
        }
    }

    protected boolean checkUsernamePassword(String username, String pw) {
        return this.checkMessageBrokerAuthentication(username, Encryptor.decrypt(pw));
    }

    public boolean isSecure() {
        return true;
    }
}

