/*
 * Decompiled with CFR 0.152.
 */
package flex.messaging.util.concurrent;

import flex.messaging.log.Log;
import flex.messaging.util.concurrent.Executor;
import flex.messaging.util.concurrent.FailedExecutionHandler;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class DefaultThreadPoolExecutor
extends ThreadPoolExecutor
implements Executor {
    private final Object lock = new Object();
    private FailedExecutionHandler handler;

    public DefaultThreadPoolExecutor() {
        super(0, Integer.MAX_VALUE, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>());
    }

    public DefaultThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue workQueue) {
        super(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue);
    }

    public DefaultThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue workQueue, RejectedExecutionHandler handler) {
        super(corePoolSize, maximumPoolSize, keepAliveTime, unit, (BlockingQueue<Runnable>)workQueue, handler);
    }

    public DefaultThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue workQueue, ThreadFactory threadFactory) {
        super(corePoolSize, maximumPoolSize, keepAliveTime, unit, (BlockingQueue<Runnable>)workQueue, threadFactory);
    }

    public DefaultThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue workQueue, ThreadFactory threadFactory, RejectedExecutionHandler handler) {
        super(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, threadFactory, handler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FailedExecutionHandler getFailedExecutionHandler() {
        Object object = this.lock;
        synchronized (object) {
            return this.handler;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFailedExecutionHandler(FailedExecutionHandler value) {
        Object object = this.lock;
        synchronized (object) {
            this.handler = value;
        }
    }

    public void execute(Runnable command) {
        block3: {
            try {
                super.execute(command);
            }
            catch (RejectedExecutionException e) {
                FailedExecutionHandler handler = this.getFailedExecutionHandler();
                if (handler != null) {
                    handler.failedExecution(command, this, e);
                }
                if (!Log.isError()) break block3;
                Log.getLogger((String)"Executor").error("DefaultThreadPoolExecutor hit a RejectedExecutionException but no FailedExecutionHandler is registered to handle the error.", (Throwable)e);
            }
        }
    }
}

