(ns com.adgoji.geo-api-context.core
  (:import
   (java.util.concurrent TimeUnit)
   (com.google.maps GeoApiContext$Builder GeoApiContext)))

(defn new
  ^GeoApiContext
  [api-key {:keys [connect-timeout-ms read-timeout-ms]
            :or   {connect-timeout-ms 60000
                   read-timeout-ms    60000}}]

  (-> (new GeoApiContext$Builder)
      (.apiKey api-key)
      (.connectTimeout connect-timeout-ms TimeUnit/MILLISECONDS)
      (.readTimeout read-timeout-ms TimeUnit/MILLISECONDS)
      (.build)))

(defn shutdown [^GeoApiContext context]
  (.shutdown context))
