(ns com.adgoji.maps-api.timezone
  (:require
   [clojure.spec.alpha :as s]
   [com.adgoji.timezone.interface :as timezone]
   [com.adgoji.maps-spec.interface :as maps-spec]))

(defn get-time-zone
  "Get the time zone for a given lat-lng."
  [context lat-lng]
  (timezone/get-time-zone context lat-lng))

(s/fdef get-time-time-zone
  :args (s/cat :context ::maps-spec/context
               :lat-lng ::maps-spec/lat-lng)
  :ret ::maps-spec/timezone)
