(ns com.adgoji.maps-api.context
  (:require
   [clojure.spec.alpha :as s]
   [com.adgoji.geo-api-context.interface :as geo-api-context]
   [com.adgoji.maps-spec.interface :as maps-spec])
  (:import
   (com.google.maps GeoApiContext)))

(defn new
  "Creates GeoApiContext."
  [api-key opts]
  (geo-api-context/new api-key opts))

(s/fdef new
  :args (s/cat :api-key ::maps-spec/api-key
               :opts ::maps-spec/context-opts)
  :ret ::maps-spec/context)

(defn shutdown
  "Shutdowns GeoApiContext."
  [^GeoApiContext context]
  (geo-api-context/shutdown context))

(s/fdef shutdown
  :args (s/cat :context ::maps-spec/context))
