(ns com.adgoji.timezone.core
  (:require
   [com.adgoji.maps-utils.interface :as maps-utils]
   [com.adgoji.maps-spec.interface :as maps-spec]
   [com.adgoji.spec.interface :as spec])
  (:import
   (com.google.maps GeoApiContext TimeZoneApi)
   (java.util TimeZone)))

(defn get-time-zone [^GeoApiContext context lat-lng]
  (let [lat-lng-conformed (spec/check lat-lng ::maps-spec/lat-lng)
        lat-lng-java      (maps-utils/clj-lat-lng->java-lat-lng lat-lng-conformed)
        ^TimeZone resp    (.await (TimeZoneApi/getTimeZone context lat-lng-java))]
    (spec/check (.getID resp) ::maps-spec/timezone)))
