(ns com.adgoji.maps-spec.geocoding
  (:require
   [clojure.spec.alpha :as s]
   [com.adgoji.maps-spec.address-component :as address-component]
   [com.adgoji.maps-spec.geometry :as geometry]
   [com.adgoji.maps-spec.plus-code :as plus-code]))

(s/def ::location string?)

(s/def ::formatted-address string?)
(s/def ::partial-match boolean?)
(s/def ::postcode-locality string?)
(s/def ::place-id string?)
(s/def ::postcode-localities
  (s/coll-of ::postcode-locality
             :into []))

(s/def ::address-component (s/keys :req-un [::address-component/long-name
                                            ::address-component/short-name
                                            ::address-component/types]))

(s/def ::address-components
  (s/coll-of ::address-component :into []))

(s/def ::geometry (s/keys :req-un [::geometry/location]
                          :opt-un [::geometry/location-type
                                   ::geometry/bounds
                                   ::geometry/viewport
                                   ::geometry/location]))

(s/def ::types (s/coll-of string? :into [] :distinct :true))
(s/def ::plus-code (s/keys :req-un [::plus-code/compound-code
                                    ::plus-code/global-code]))

(s/def ::geocoding-result
  (s/keys :req-un [::geometry]
          :opt-un [::address-components
                   ::types
                   ::formatted-address
                   ::partial-match
                   ::place-id
                   ::postcode-localities
                   ::plus-code]))
