(ns com.adgoji.maps-api.geocoding
  (:require
   [com.adgoji.geocoding.interface :as geocoding]
   [com.adgoji.maps-spec.interface :as maps-spec]
   [clojure.spec.alpha :as s]))

(defn geocode
  "Get coordinates for a given location."
  [context location]
  (geocoding/geocode context location))

(s/fdef geocode
  :args (s/cat :context ::maps-spec/context
               :location ::maps-spec/location)
  :ret ::maps-spec/geocoding-results)
