(ns com.adgoji.doubleclick-spec.doubleclick.query.metadata
  (:require
   [clojure.spec.alpha :as s]
   [com.adgoji.doubleclick-spec.doubleclick.data-range :as data-range]
   [com.adgoji.spec.interface :as spec]
   [com.adgoji.doubleclick-spec.doubleclick.format :as format]))

(s/def ::title string?)
(s/def ::data-range ::data-range/spec)
(s/def ::format ::format/spec)
(s/def ::send-notification boolean?)
(s/def ::share-email-address
  (s/coll-of string? :into [] :distinct true))
(s/def ::spec
  (spec/only-keys :opt-un [::title
                           ::data-range
                           ::format
                           ::send-notification
                           ::share-email-address]))
