(ns com.adgoji.doubleclick-api.queries
  (:require
   [clojure.spec.alpha :as s]
   [com.adgoji.doubleclick-spec.interface :as doubleclick-spec]
   [com.adgoji.queries.interface :as queries]))

(defn create
  "Create a new query."
  [client query]
  (queries/create client query))

(s/fdef create
  :args (s/cat :client ::doubleclick-spec/doubleclick-client
               :query ::doubleclick-spec/query)
  :ret ::doubleclick-spec/query)

(defn get-by-id
  "Return a single query by `query-id`."
  [client query-id]
  (queries/get-by-id client query-id))

(s/fdef get-by-id
  :args (s/cat :client ::doubleclick-spec/doubleclick-client
               :query-id ::doubleclick-spec/query-id))

(defn get-list
  "Return a list of all saved queries."
  [client opts]
  (queries/get-list client opts))

(s/fdef get-list
  :args (s/cat :client ::doubleclick-spec/doubleclick-client
               :opts (s/keys :opt-un [::doubleclick-spec/order-by
                                      ::doubleclick-spec/limit]))
  :ret ::doubleclick-spec/queries)

(defn delete
  "Deletes a query by `query-id` as well as the associated reports."
  [client query-id]
  (queries/delete client query-id))

(s/fdef delete
  :args (s/cat :client ::doubleclick-spec/doubleclick-client
               :query-id ::doubleclick-spec/query-id)
  :ret nil?)

(defn run
  "Run a stored query to generate a report.

  Query can be run in synchronously or asynchronously. This behavior
  is controlled by `synchronous` parameter. When true, this funcrtion
  will not return until the query has finished running. When false or
  not doubleclick-specified, this function will return immediately."
  ([client query-id run-query-request]
   (run client query-id run-query-request false))
  ([client query-id run-query-request synchronous]
   (queries/run client query-id run-query-request synchronous)))

(s/fdef run
  :args (s/or :default (s/cat :client ::doubleclick-spec/doubleclick-client
                              :query-id ::doubleclick-spec/query-id
                              :run-query-request ::doubleclick-spec/run-query-request)
              :synchronous-optional (s/cat :client ::doubleclick-spec/doubleclick-client
                                           :query-id ::doubleclick-spec/query-id
                                           :run-query-request ::doubleclick-spec/run-query-request
                                           :synchronous ::doubleclick-spec/synchronous))
  :ret ::doubleclick-spec/report)
