(ns com.adgoji.spec.utils
  (:require
   [clojure.spec.alpha :as s]))

(defn check
  [v spec]
  (let [parsed (s/conform spec v)]
    (if (s/invalid? parsed)
      (throw (ex-info "Spec check failed" (or (s/explain-data spec v) {})))
      parsed)))

(defn- strict-int-conform
  [n]
  (if (int? n)
    (int n)
    ::s/invalid))

(def strict-int? (s/conformer strict-int-conform))

(defn- strict-long-conform
  [n]
  (if (int? n)
    (long n)
    ::s/invalid))

(def strict-long? (s/conformer strict-long-conform))
