(ns com.adgoji.doubleclick-spec.doubleclick.query.schedule
  (:require
   [clojure.spec.alpha :as s]
   [com.adgoji.doubleclick-spec.doubleclick.date :as date]
   [com.adgoji.spec.interface :as spec]))

(s/def ::start-date ::date/spec)
(s/def ::end-date ::date/spec)
(s/def ::frequency
  #{"FREQUENCY_UNSPECIFIED"
    "ONE_TIME"
    "DAILY"
    "WEEKLY"
    "SEMI_MONTHLY"
    "MONTHLY"
    "QUARTERLY"
    "YEARLY"})
(s/def ::next-run-timezone-code string?)
(s/def ::spec
  (spec/only-keys :req-un [::frequency]
                  :opt-un [::start-date
                           ::end-date
                           ::next-run-timezone-code]))
