(ns com.adgoji.doubleclick-api.client
  (:require
   [com.adgoji.doubleclick-client.interface :as doubleclick-client]
   [com.adgoji.google-credential.interface :as google-credential])
  (:import
   (com.google.api.client.auth.oauth2 Credential)
   (com.google.api.services.doubleclickbidmanager DoubleClickBidManager DoubleClickBidManagerScopes)))

(def ^:private ->scope
  {:doubleclickbidmanager DoubleClickBidManagerScopes/DOUBLECLICKBIDMANAGER})

(defn- convert-scopes
  [scopes]
  (if (coll? scopes)
    (let [scopes-xf
          (cond->> (filter (partial contains? (set (DoubleClickBidManagerScopes/all))))
            (every? keyword? scopes) (comp (map ->scope)))]
      (into #{} scopes-xf scopes))
    (if (and (keyword? scopes)
             (= :all ^clojure.lang.Keyword scopes))
      (set (DoubleClickBidManagerScopes/all))
      (throw (ex-info "Invalid scopes" {:scopes scopes})))))

(defn google-credential
  [opts]
  (google-credential/new (update opts :scopes convert-scopes)))

(defn new
  ^DoubleClickBidManager
  [^Credential credential ^String application-name opts]
  (doubleclick-client/new credential application-name opts))
