(ns com.adgoji.doubleclick-spec.doubleclick
  (:require
   [clojure.spec.alpha :as s]
   [com.adgoji.doubleclick-spec.doubleclick.query :as query]
   [com.adgoji.doubleclick-spec.doubleclick.run-query-request :as run-query-request]
   [com.adgoji.doubleclick-spec.doubleclick.report :as report])
  (:import
   (com.google.api.services.doubleclickbidmanager DoubleClickBidManager)))

(s/def ::client (partial instance? DoubleClickBidManager))
(s/def ::synchronous boolean?)
(s/def ::order-by string?)
(s/def ::limit int?)

(s/def ::query ::query/spec)

(s/def ::queries
  (s/coll-of ::query :into [] :distinct true))

(s/def ::run-query-request ::run-query-request/spec)

(s/def ::report ::report/spec)

(s/def ::reports
  (s/coll-of ::report :into [] :distinct true))
