(ns com.adgoji.doubleclick-api.queries.reports
  (:require
   [com.adgoji.reports.interface :as reports]
   [clojure.spec.alpha :as s]
   [com.adgoji.doubleclick-spec.interface :as doubleclick-spec]))

(defn get-by-id
  "Get a single report by `query-id` and `report-id`."
  [client query-id report-id]
  (reports/get-by-id client query-id report-id))

(s/fdef get-by-id
  :args (s/cat :client ::doubleclick-spec/doubleclick-client
               :query-id ::doubleclick-spec/query-id
               :report-id ::doubleclick-spec/report-id)
  :ret ::doubleclick-spec/report)

(defn get-list
  "Get list of reports by `query-id`.

  If `limit` is not provided, returns all items from all pages.

  Sorting is only possible by `report-id`, so `order-by` can be one of
  the following options:
  - \"key.reportId\"
  - \"key.reportId desc\" (note space before `desc`)."
  [client query-id opts]
  (reports/get-list client query-id opts))

(s/fdef get-list
  :args (s/cat :client ::doubleclick-spec/doubleclick-client
               :query-id ::doubleclick-spec/query-id
               :opts (s/keys :opt-un [::doubleclick-spec/order-by
                                      ::doubleclick-spec/limit]))
  :ret ::doubleclick-spec/reports)
