(ns com.adgoji.doubleclick-spec.doubleclick.parameters
  (:require
   [clojure.spec.alpha :as s]
   [com.adgoji.doubleclick-spec.doubleclick.filter-pair :as filter-pair]
   [com.adgoji.doubleclick-spec.doubleclick.options :as options]
   [com.adgoji.spec.interface :as spec]))

(s/def ::type
  #{"REPORT_TYPE_UNSPECIFIED"
    "STANDARD"
    "INVENTORY_AVAILABILITY"
    "AUDIENCE_COMPOSITION"
    "FLOODLIGHT"
    "YOUTUBE"
    "GRP"
    "YOUTUBE_PROGRAMMATIC_GUARANTEED"
    "REACH"
    "UNIQUE_REACH_AUDIENCE"
    "FULL_PATH"
    "PATH_ATTRIBUTION"})

(s/def ::group-bys
  (s/coll-of ::filter-pair/type :into [] :distinct true))

(s/def ::filters
  (s/coll-of ::filter-pair/spec :into [] :distinct true))

(s/def ::metric
  #{"METRIC_ACTIVE_VIEW_AUDIBLE_2_SEC_IMPRESSIONS"
    "METRIC_ACTIVE_VIEW_AUDIBLE_AND_BACKGROUND_IMPRESSIONS"
    "METRIC_ACTIVE_VIEW_AUDIBLE_FULLY_ON_SCREEN_HALF_OF_DURATION_IMPRESSIONS"
    "METRIC_ACTIVE_VIEW_AUDIBLE_FULLY_ON_SCREEN_HALF_OF_DURATION_MEASURABLE_IMPRESSIONS"
    "METRIC_ACTIVE_VIEW_AUDIBLE_FULLY_ON_SCREEN_HALF_OF_DURATION_RATE"
    "METRIC_ACTIVE_VIEW_AUDIBLE_FULLY_ON_SCREEN_HALF_OF_DURATION_TRUEVIEW_IMPRESSIONS"
    "METRIC_ACTIVE_VIEW_AUDIBLE_FULLY_ON_SCREEN_HALF_OF_DURATION_TRUEVIEW_MEASURABLE_IMPRESSIONS"
    "METRIC_ACTIVE_VIEW_AUDIBLE_FULLY_ON_SCREEN_HALF_OF_DURATION_TRUEVIEW_RATE"
    "METRIC_ACTIVE_VIEW_AUDIBLE_VISIBLE_ON_COMPLETE_IMPRESSIONS"
    "METRIC_ACTIVE_VIEW_AVERAGE_VIEWABLE_TIME"
    "METRIC_ACTIVE_VIEW_CUSTOM_METRIC_MEASURABLE_IMPRESSIONS"
    "METRIC_ACTIVE_VIEW_CUSTOM_METRIC_VIEWABLE_IMPRESSIONS"
    "METRIC_ACTIVE_VIEW_CUSTOM_METRIC_VIEWABLE_RATE"
    "METRIC_ACTIVE_VIEW_DISTRIBUTION_UNMEASURABLE"
    "METRIC_ACTIVE_VIEW_DISTRIBUTION_UNVIEWABLE"
    "METRIC_ACTIVE_VIEW_DISTRIBUTION_VIEWABLE"
    "METRIC_ACTIVE_VIEW_ELIGIBLE_IMPRESSIONS"
    "METRIC_ACTIVE_VIEW_MEASURABLE_IMPRESSIONS"
    "METRIC_ACTIVE_VIEW_PCT_MEASURABLE_IMPRESSIONS"
    "METRIC_ACTIVE_VIEW_PCT_VIEWABLE_IMPRESSIONS"
    "METRIC_ACTIVE_VIEW_PERCENT_AUDIBLE_2_SEC"
    "METRIC_ACTIVE_VIEW_PERCENT_AUDIBLE_30_SEC"
    "METRIC_ACTIVE_VIEW_PERCENT_AUDIBLE_AND_BACKGROUND"
    "METRIC_ACTIVE_VIEW_PERCENT_AUDIBLE_IMPRESSIONS"
    "METRIC_ACTIVE_VIEW_PERCENT_AUDIBLE_VISIBLE_AT_START"
    "METRIC_ACTIVE_VIEW_PERCENT_AUDIBLE_VISIBLE_FIRST_QUAR"
    "METRIC_ACTIVE_VIEW_PERCENT_AUDIBLE_VISIBLE_ON_COMPLETE"
    "METRIC_ACTIVE_VIEW_PERCENT_AUDIBLE_VISIBLE_SECOND_QUAR"
    "METRIC_ACTIVE_VIEW_PERCENT_AUDIBLE_VISIBLE_THIRD_QUAR"
    "METRIC_ACTIVE_VIEW_PERCENT_COMPLETE_AUDIBLE"
    "METRIC_ACTIVE_VIEW_PERCENT_EVER_MUTED"
    "METRIC_ACTIVE_VIEW_PERCENT_FIRST_QUARTILE_AUDIBLE"
    "METRIC_ACTIVE_VIEW_PERCENT_FULLY_ON_SCREEN_2_SEC"
    "METRIC_ACTIVE_VIEW_PERCENT_FULL_SCREEN"
    "METRIC_ACTIVE_VIEW_PERCENT_IN_BACKGROUND"
    "METRIC_ACTIVE_VIEW_PERCENT_MIDPOINT_AUDIBLE"
    "METRIC_ACTIVE_VIEW_PERCENT_OF_AD_PLAYED"
    "METRIC_ACTIVE_VIEW_PERCENT_OF_COMPLETED_IMPRESSIONS_AUDIBLE_AND_VISIBLE"
    "METRIC_ACTIVE_VIEW_PERCENT_OF_COMPLETED_IMPRESSIONS_VISIBLE"
    "METRIC_ACTIVE_VIEW_PERCENT_OF_FIRST_QUARTILE_IMPRESSIONS_AUDIBLE_AND_VISIBLE"
    "METRIC_ACTIVE_VIEW_PERCENT_OF_FIRST_QUARTILE_IMPRESSIONS_VISIBLE"
    "METRIC_ACTIVE_VIEW_PERCENT_OF_MIDPOINT_IMPRESSIONS_AUDIBLE_AND_VISIBLE"
    "METRIC_ACTIVE_VIEW_PERCENT_OF_MIDPOINT_IMPRESSIONS_VISIBLE"
    "METRIC_ACTIVE_VIEW_PERCENT_OF_THIRD_QUARTILE_IMPRESSIONS_AUDIBLE_AND_VISIBLE"
    "METRIC_ACTIVE_VIEW_PERCENT_OF_THIRD_QUARTILE_IMPRESSIONS_VISIBLE"
    "METRIC_ACTIVE_VIEW_PERCENT_PLAY_TIME_AUDIBLE"
    "METRIC_ACTIVE_VIEW_PERCENT_PLAY_TIME_AUDIBLE_AND_VISIBLE"
    "METRIC_ACTIVE_VIEW_PERCENT_PLAY_TIME_VISIBLE"
    "METRIC_ACTIVE_VIEW_PERCENT_THIRD_QUARTILE_AUDIBLE"
    "METRIC_ACTIVE_VIEW_PERCENT_VIEWABLE_FOR_TIME_THRESHOLD"
    "METRIC_ACTIVE_VIEW_PERCENT_VISIBLE_AT_START"
    "METRIC_ACTIVE_VIEW_PERCENT_VISIBLE_FIRST_QUAR"
    "METRIC_ACTIVE_VIEW_PERCENT_VISIBLE_ON_COMPLETE"
    "METRIC_ACTIVE_VIEW_PERCENT_VISIBLE_SECOND_QUAR"
    "METRIC_ACTIVE_VIEW_PERCENT_VISIBLE_THIRD_QUAR"
    "METRIC_ACTIVE_VIEW_UNMEASURABLE_IMPRESSIONS"
    "METRIC_ACTIVE_VIEW_UNVIEWABLE_IMPRESSIONS"
    "METRIC_ACTIVE_VIEW_VIEWABLE_FOR_TIME_THRESHOLD"
    "METRIC_ACTIVE_VIEW_VIEWABLE_IMPRESSIONS"
    "METRIC_ACTIVITY_REVENUE"
    "METRIC_ADAPTED_AUDIENCE_FREQUENCY"
    "METRIC_ADLINGO_FEE_ADVERTISER_CURRENCY"
    "METRIC_ADLINGO_FEE_PARTNER_CURRENCY"
    "METRIC_ADLINGO_FEE_USD"
    "METRIC_AUDIO_CLIENT_COST_ECPCL_ADVERTISER_CURRENCY"
    "METRIC_AUDIO_MEDIA_COST_ECPCL_ADVERTISER_CURRENCY"
    "METRIC_AUDIO_MUTES_AUDIO"
    "METRIC_AUDIO_REVENUE_ECPCL_ADVERTISER_CURRENCY"
    "METRIC_AUDIO_UNMUTES_AUDIO"
    "METRIC_AUDIO_UNMUTES_VIDEO"
    "METRIC_AVERAGE_DISPLAY_TIME"
    "METRIC_AVERAGE_IMPRESSION_FREQUENCY_PER_USER"
    "METRIC_AVERAGE_IMPRESSION_FREQUENCY_PER_USER_7DAYS"
    "METRIC_AVERAGE_INTERACTION_TIME"
    "METRIC_AVERAGE_WATCH_TIME_PER_IMPRESSION"
    "METRIC_BEGIN_TO_RENDER_ELIGIBLE_IMPRESSIONS"
    "METRIC_BEGIN_TO_RENDER_IMPRESSIONS"
    "METRIC_BENCHMARK_FREQUENCY"
    "METRIC_BID_REQUESTS"
    "METRIC_BILLABLE_COST_ADVERTISER"
    "METRIC_BILLABLE_COST_PARTNER"
    "METRIC_BILLABLE_COST_USD"
    "METRIC_BILLABLE_IMPRESSIONS"
    "METRIC_BRAND_LIFT_ABSOLUTE_BRAND_LIFT"
    "METRIC_BRAND_LIFT_ALL_SURVEY_RESPONSES"
    "METRIC_BRAND_LIFT_BASELINE_POSITIVE_RESPONSE_RATE"
    "METRIC_BRAND_LIFT_BASELINE_SURVEY_RESPONSES"
    "METRIC_BRAND_LIFT_COST_PER_LIFTED_USER"
    "METRIC_BRAND_LIFT_EXPOSED_SURVEY_RESPONSES"
    "METRIC_BRAND_LIFT_HEADROOM_BRAND_LIFT"
    "METRIC_BRAND_LIFT_RELATIVE_BRAND_LIFT"
    "METRIC_BRAND_LIFT_USERS"
    "METRIC_CARD_CLICKS"
    "METRIC_CLICKS"
    "METRIC_CLICK_TO_POST_CLICK_CONVERSION_RATE"
    "METRIC_CLIENT_COST_ADVERTISER_CURRENCY"
    "METRIC_CLIENT_COST_ECPA_ADVERTISER_CURRENCY"
    "METRIC_CLIENT_COST_ECPA_PC_ADVERTISER_CURRENCY"
    "METRIC_CLIENT_COST_ECPA_PV_ADVERTISER_CURRENCY"
    "METRIC_CLIENT_COST_ECPC_ADVERTISER_CURRENCY"
    "METRIC_CLIENT_COST_ECPM_ADVERTISER_CURRENCY"
    "METRIC_CLIENT_COST_VIEWABLE_ECPM_ADVERTISER_CURRENCY"
    "METRIC_CM360_POST_CLICK_REVENUE"
    "METRIC_CM360_POST_CLICK_REVENUE_CROSS_ENVIRONMENT"
    "METRIC_CM360_POST_VIEW_REVENUE"
    "METRIC_CM360_POST_VIEW_REVENUE_CROSS_ENVIRONMENT"
    "METRIC_COMPANION_CLICKS_AUDIO"
    "METRIC_COMPANION_IMPRESSIONS_AUDIO"
    "METRIC_COMPLETE_LISTENS_AUDIO"
    "METRIC_COMPLETION_RATE_AUDIO"
    "METRIC_CONVERSIONS_PER_MILLE"
    "METRIC_CONVERTING_PATHS"
    "METRIC_COOKIE_CONSENTED_FLOODLIGHT_IMPRESSIONS"
    "METRIC_COOKIE_REACH_AVERAGE_IMPRESSION_FREQUENCY"
    "METRIC_COOKIE_REACH_IMPRESSION_REACH"
    "METRIC_COOKIE_UNCONSENTED_FLOODLIGHT_IMPRESSIONS"
    "METRIC_COUNTERS"
    "METRIC_CPM_FEE1_ADVERTISER"
    "METRIC_CPM_FEE1_PARTNER"
    "METRIC_CPM_FEE1_USD"
    "METRIC_CPM_FEE2_ADVERTISER"
    "METRIC_CPM_FEE2_PARTNER"
    "METRIC_CPM_FEE2_USD"
    "METRIC_CPM_FEE3_ADVERTISER"
    "METRIC_CPM_FEE3_PARTNER"
    "METRIC_CPM_FEE3_USD"
    "METRIC_CPM_FEE4_ADVERTISER"
    "METRIC_CPM_FEE4_PARTNER"
    "METRIC_CPM_FEE4_USD"
    "METRIC_CPM_FEE5_ADVERTISER"
    "METRIC_CPM_FEE5_PARTNER"
    "METRIC_CPM_FEE5_USD"
    "METRIC_CTR"
    "METRIC_CUSTOM_FEE_1_ADVERTISER_CURRENCY"
    "METRIC_CUSTOM_FEE_2_ADVERTISER_CURRENCY"
    "METRIC_CUSTOM_FEE_3_ADVERTISER_CURRENCY"
    "METRIC_CUSTOM_FEE_4_ADVERTISER_CURRENCY"
    "METRIC_CUSTOM_FEE_5_ADVERTISER_CURRENCY"
    "METRIC_CUSTOM_VALUE_PER_1000_IMPRESSIONS"
    "METRIC_DATA_COST_ADVERTISER"
    "METRIC_DATA_COST_PARTNER"
    "METRIC_DATA_COST_USD"
    "METRIC_DEMO_COMPOSITION_IMPRESSION"
    "METRIC_DEMO_COMPOSITION_IMPRESSION_COVIEWED"
    "METRIC_DEMO_CORRECTED_CLICKS"
    "METRIC_DEMO_POPULATION"
    "METRIC_DUPLICATE_FLOODLIGHT_IMPRESSIONS"
    "METRIC_ENGAGEMENTS"
    "METRIC_ENGAGEMENT_RATE"
    "METRIC_ESTIMATED_CPM_FOR_IMPRESSIONS_WITH_CUSTOM_VALUE_ADVERTISER_CURRENCY"
    "METRIC_ESTIMATED_TOTAL_COST_FOR_IMPRESSIONS_WITH_CUSTOM_VALUE_ADVERTISER_CURRENCY"
    "METRIC_EXITS"
    "METRIC_EXPANSIONS"
    "METRIC_FEE10_ADVERTISER"
    "METRIC_FEE10_PARTNER"
    "METRIC_FEE10_USD"
    "METRIC_FEE11_ADVERTISER"
    "METRIC_FEE11_PARTNER"
    "METRIC_FEE11_USD"
    "METRIC_FEE12_ADVERTISER"
    "METRIC_FEE12_PARTNER"
    "METRIC_FEE12_USD"
    "METRIC_FEE13_ADVERTISER"
    "METRIC_FEE13_PARTNER"
    "METRIC_FEE13_USD"
    "METRIC_FEE14_ADVERTISER"
    "METRIC_FEE14_PARTNER"
    "METRIC_FEE14_USD"
    "METRIC_FEE15_ADVERTISER"
    "METRIC_FEE15_PARTNER"
    "METRIC_FEE15_USD"
    "METRIC_FEE16_ADVERTISER"
    "METRIC_FEE16_PARTNER"
    "METRIC_FEE16_USD"
    "METRIC_FEE17_ADVERTISER"
    "METRIC_FEE17_PARTNER"
    "METRIC_FEE17_USD"
    "METRIC_FEE18_ADVERTISER"
    "METRIC_FEE18_PARTNER"
    "METRIC_FEE18_USD"
    "METRIC_FEE19_ADVERTISER"
    "METRIC_FEE19_PARTNER"
    "METRIC_FEE19_USD"
    "METRIC_FEE20_ADVERTISER"
    "METRIC_FEE20_PARTNER"
    "METRIC_FEE20_USD"
    "METRIC_FEE21_ADVERTISER"
    "METRIC_FEE21_PARTNER"
    "METRIC_FEE21_USD"
    "METRIC_FEE22_ADVERTISER"
    "METRIC_FEE22_PARTNER"
    "METRIC_FEE22_USD"
    "METRIC_FEE2_ADVERTISER"
    "METRIC_FEE2_PARTNER"
    "METRIC_FEE2_USD"
    "METRIC_FEE31_ADVERTISER"
    "METRIC_FEE31_PARTNER"
    "METRIC_FEE31_USD"
    "METRIC_FEE32_ADVERTISER"
    "METRIC_FEE32_PARTNER"
    "METRIC_FEE32_USD"
    "METRIC_FEE3_ADVERTISER"
    "METRIC_FEE3_PARTNER"
    "METRIC_FEE3_USD"
    "METRIC_FEE4_ADVERTISER"
    "METRIC_FEE4_PARTNER"
    "METRIC_FEE4_USD"
    "METRIC_FEE5_ADVERTISER"
    "METRIC_FEE5_PARTNER"
    "METRIC_FEE5_USD"
    "METRIC_FEE6_ADVERTISER"
    "METRIC_FEE6_PARTNER"
    "METRIC_FEE6_USD"
    "METRIC_FEE7_ADVERTISER"
    "METRIC_FEE7_PARTNER"
    "METRIC_FEE7_USD"
    "METRIC_FEE8_ADVERTISER"
    "METRIC_FEE8_PARTNER"
    "METRIC_FEE8_USD"
    "METRIC_FEE9_ADVERTISER"
    "METRIC_FEE9_PARTNER"
    "METRIC_FEE9_USD"
    "METRIC_FIRST_QUARTILE_AUDIO"
    "METRIC_FLOODLIGHT_IMPRESSIONS"
    "METRIC_GENERAL_INVALID_TRAFFIC_GIVT_IMPRESSIONS"
    "METRIC_GENERAL_INVALID_TRAFFIC_GIVT_TRACKED_ADS"
    "METRIC_GIVT_ACTIVE_VIEW_AUDIBLE_IMPRESSIONS"
    "METRIC_GIVT_ACTIVE_VIEW_ELIGIBLE_IMPRESSIONS"
    "METRIC_GIVT_ACTIVE_VIEW_MEASURABLE_IMPRESSIONS"
    "METRIC_GIVT_ACTIVE_VIEW_VIEWABLE_IMPRESSIONS"
    "METRIC_GIVT_BEGIN_TO_RENDER_IMPRESSIONS"
    "METRIC_GIVT_CLICKS"
    "METRIC_GMAIL_CONVERSIONS"
    "METRIC_GMAIL_POST_CLICK_CONVERSIONS"
    "METRIC_GMAIL_POST_VIEW_CONVERSIONS"
    "METRIC_GRP_CORRECTED_IMPRESSIONS"
    "METRIC_GRP_CORRECTED_IMPRESSIONS_COVIEWED"
    "METRIC_GRP_CORRECTED_VIEWABLE_IMPRESSIONS"
    "METRIC_GRP_CORRECTED_VIEWABLE_IMPRESSIONS_SHARE_PERCENT"
    "METRIC_IMPRESSIONS"
    "METRIC_IMPRESSIONS_COVIEWED"
    "METRIC_IMPRESSIONS_TO_CONVERSION_RATE"
    "METRIC_IMPRESSIONS_WITH_CUSTOM_VALUE"
    "METRIC_IMPRESSIONS_WITH_POSITIVE_CUSTOM_VALUE"
    "METRIC_IMPRESSION_CUSTOM_VALUE_COST"
    "METRIC_IMPRESSION_LOSS_TARGETED_IMPRESSIONS"
    "METRIC_INACTIVE_IMPRESSIONS"
    "METRIC_INTERACTIVE_IMPRESSIONS"
    "METRIC_INVALID_ACTIVE_VIEW_AUDIBLE_IMPRESSIONS"
    "METRIC_INVALID_ACTIVE_VIEW_ELIGIBLE_IMPRESSIONS"
    "METRIC_INVALID_ACTIVE_VIEW_MEASURABLE_IMPRESSIONS"
    "METRIC_INVALID_ACTIVE_VIEW_VIEWABLE_IMPRESSIONS"
    "METRIC_INVALID_BEGIN_TO_RENDER_IMPRESSIONS"
    "METRIC_INVALID_CLICKS"
    "METRIC_INVALID_IMPRESSIONS"
    "METRIC_INVALID_TRACKED_ADS"
    "METRIC_LAST_CLICKS"
    "METRIC_LAST_IMPRESSIONS"
    "METRIC_LAST_TOUCH_CLICK_THROUGH_CONVERSIONS"
    "METRIC_LAST_TOUCH_TOTAL_CONVERSIONS"
    "METRIC_LAST_TOUCH_VIEW_THROUGH_CONVERSIONS"
    "METRIC_LINEITEM_BID_RESPONSE_COUNT"
    "METRIC_MEDIA_COST_ADVERTISER"
    "METRIC_MEDIA_COST_ECPAPC_ADVERTISER"
    "METRIC_MEDIA_COST_ECPAPC_PARTNER"
    "METRIC_MEDIA_COST_ECPAPC_USD"
    "METRIC_MEDIA_COST_ECPAPV_ADVERTISER"
    "METRIC_MEDIA_COST_ECPAPV_PARTNER"
    "METRIC_MEDIA_COST_ECPAPV_USD"
    "METRIC_MEDIA_COST_ECPA_ADVERTISER"
    "METRIC_MEDIA_COST_ECPA_PARTNER"
    "METRIC_MEDIA_COST_ECPA_USD"
    "METRIC_MEDIA_COST_ECPCV_ADVERTISER"
    "METRIC_MEDIA_COST_ECPCV_PARTNER"
    "METRIC_MEDIA_COST_ECPCV_USD"
    "METRIC_MEDIA_COST_ECPC_ADVERTISER"
    "METRIC_MEDIA_COST_ECPC_PARTNER"
    "METRIC_MEDIA_COST_ECPC_USD"
    "METRIC_MEDIA_COST_ECPM_ADVERTISER"
    "METRIC_MEDIA_COST_ECPM_PARTNER"
    "METRIC_MEDIA_COST_ECPM_USD"
    "METRIC_MEDIA_COST_PARTNER"
    "METRIC_MEDIA_COST_USD"
    "METRIC_MEDIA_COST_VIEWABLE_ECPM_ADVERTISER"
    "METRIC_MEDIA_COST_VIEWABLE_ECPM_PARTNER"
    "METRIC_MEDIA_COST_VIEWABLE_ECPM_USD"
    "METRIC_MEDIA_FEE1_ADVERTISER"
    "METRIC_MEDIA_FEE1_PARTNER"
    "METRIC_MEDIA_FEE1_USD"
    "METRIC_MEDIA_FEE2_ADVERTISER"
    "METRIC_MEDIA_FEE2_PARTNER"
    "METRIC_MEDIA_FEE2_USD"
    "METRIC_MEDIA_FEE3_ADVERTISER"
    "METRIC_MEDIA_FEE3_PARTNER"
    "METRIC_MEDIA_FEE3_USD"
    "METRIC_MEDIA_FEE4_ADVERTISER"
    "METRIC_MEDIA_FEE4_PARTNER"
    "METRIC_MEDIA_FEE4_USD"
    "METRIC_MEDIA_FEE5_ADVERTISER"
    "METRIC_MEDIA_FEE5_PARTNER"
    "METRIC_MEDIA_FEE5_USD"
    "METRIC_MIDPOINT_AUDIO"
    "METRIC_NIELSEN_AVERAGE_FREQUENCY"
    "METRIC_NIELSEN_GRP"
    "METRIC_NIELSEN_IMPRESSIONS"
    "METRIC_NIELSEN_IMPRESSIONS_SHARE"
    "METRIC_NIELSEN_IMPRESSION_INDEX"
    "METRIC_NIELSEN_POPULATION"
    "METRIC_NIELSEN_POPULATION_REACH"
    "METRIC_NIELSEN_POPULATION_SHARE"
    "METRIC_NIELSEN_REACH_INDEX"
    "METRIC_NIELSEN_REACH_SHARE"
    "METRIC_NIELSEN_UNIQUE_AUDIENCE"
    "METRIC_ORIGINAL_AUDIENCE_FREQUENCY"
    "METRIC_PATH_CONVERSION_RATE"
    "METRIC_PAUSES_AUDIO"
    "METRIC_PERCENTAGE_FROM_CURRENT_IO_GOAL"
    "METRIC_PERCENT_IMPRESSIONS_WITH_POSITIVE_CUSTOM_VALUE"
    "METRIC_PERCENT_INVALID_IMPRESSIONS_PREBID"
    "METRIC_PLATFORM_FEE_ADVERTISER"
    "METRIC_PLATFORM_FEE_PARTNER"
    "METRIC_PLATFORM_FEE_RATE"
    "METRIC_PLATFORM_FEE_USD"
    "METRIC_POST_CLICK_CONVERSIONS_CROSS_ENVIRONMENT"
    "METRIC_POST_VIEW_CONVERSIONS_CROSS_ENVIRONMENT"
    "METRIC_POTENTIAL_VIEWS"
    "METRIC_PREMIUM_FEE_ADVERTISER_CURRENCY"
    "METRIC_PREMIUM_FEE_PARTNER_CURRENCY"
    "METRIC_PREMIUM_FEE_USD"
    "METRIC_PROFIT_ADVERTISER"
    "METRIC_PROFIT_ECPM_ADVERTISER"
    "METRIC_PROFIT_ECPM_PARTNER"
    "METRIC_PROFIT_ECPM_USD"
    "METRIC_PROFIT_MARGIN"
    "METRIC_PROFIT_PARTNER"
    "METRIC_PROFIT_USD"
    "METRIC_PROFIT_VIEWABLE_ECPM_ADVERTISER"
    "METRIC_PROFIT_VIEWABLE_ECPM_PARTNER"
    "METRIC_PROFIT_VIEWABLE_ECPM_USD"
    "METRIC_PROGRAMMATIC_GUARANTEED_IMPRESSIONS_PASSED_DUE_TO_FREQUENCY"
    "METRIC_PROGRAMMATIC_GUARANTEED_SAVINGS_RE_INVESTED_DUE_TO_FREQUENCY_ADVERTISER_CURRENCY"
    "METRIC_PROVISIONAL_IMPRESSIONS"
    "METRIC_REFUND_BILLABLE_COST_ADVERTISER_CURRENCY"
    "METRIC_REFUND_MEDIA_COST_ADVERTISER_CURRENCY"
    "METRIC_REFUND_PLATFORM_FEE_ADVERTISER_CURRENCY"
    "METRIC_REVENUE_ADVERTISER"
    "METRIC_REVENUE_ECPAPC_ADVERTISER"
    "METRIC_REVENUE_ECPAPC_PARTNER"
    "METRIC_REVENUE_ECPAPC_USD"
    "METRIC_REVENUE_ECPAPV_ADVERTISER"
    "METRIC_REVENUE_ECPAPV_PARTNER"
    "METRIC_REVENUE_ECPAPV_USD"
    "METRIC_REVENUE_ECPA_ADVERTISER"
    "METRIC_REVENUE_ECPA_PARTNER"
    "METRIC_REVENUE_ECPA_USD"
    "METRIC_REVENUE_ECPCV_ADVERTISER"
    "METRIC_REVENUE_ECPCV_PARTNER"
    "METRIC_REVENUE_ECPCV_USD"
    "METRIC_REVENUE_ECPC_ADVERTISER"
    "METRIC_REVENUE_ECPC_PARTNER"
    "METRIC_REVENUE_ECPC_USD"
    "METRIC_REVENUE_ECPM_ADVERTISER"
    "METRIC_REVENUE_ECPM_PARTNER"
    "METRIC_REVENUE_ECPM_USD"
    "METRIC_REVENUE_PARTNER"
    "METRIC_REVENUE_USD"
    "METRIC_REVENUE_VIEWABLE_ECPM_ADVERTISER"
    "METRIC_REVENUE_VIEWABLE_ECPM_PARTNER"
    "METRIC_REVENUE_VIEWABLE_ECPM_USD"
    "METRIC_RICH_MEDIA_ENGAGEMENTS"
    "METRIC_RICH_MEDIA_SCROLLS"
    "METRIC_RICH_MEDIA_VIDEO_COMPLETIONS"
    "METRIC_RICH_MEDIA_VIDEO_FIRST_QUARTILE_COMPLETES"
    "METRIC_RICH_MEDIA_VIDEO_FULL_SCREENS"
    "METRIC_RICH_MEDIA_VIDEO_MIDPOINTS"
    "METRIC_RICH_MEDIA_VIDEO_MUTES"
    "METRIC_RICH_MEDIA_VIDEO_PAUSES"
    "METRIC_RICH_MEDIA_VIDEO_PLAYS"
    "METRIC_RICH_MEDIA_VIDEO_SKIPS"
    "METRIC_RICH_MEDIA_VIDEO_THIRD_QUARTILE_COMPLETES"
    "METRIC_STARTS_AUDIO"
    "METRIC_STOPS_AUDIO"
    "METRIC_STORE_VISIT_CONVERSIONS"
    "METRIC_STORE_VISIT_VIEW_THROUGH_CONVERSIONS"
    "METRIC_TARGET_RATING_POINTS"
    "METRIC_TARGET_RATING_POINTS_COVIEWED"
    "METRIC_TEA_TRUEVIEW_IMPRESSIONS"
    "METRIC_TEA_TRUEVIEW_UNIQUE_COOKIES"
    "METRIC_THIRD_QUARTILE_AUDIO"
    "METRIC_TIMERS"
    "METRIC_TOTAL_AUDIO_MEDIA_COST_ECPCL_ADVERTISER_CURRENCY"
    "METRIC_TOTAL_CONVERSIONS"
    "METRIC_TOTAL_CONVERSIONS_CROSS_ENVIRONMENT"
    "METRIC_TOTAL_DISPLAY_TIME"
    "METRIC_TOTAL_EXPOSURES"
    "METRIC_TOTAL_IMPRESSION_CUSTOM_VALUE"
    "METRIC_TOTAL_INTERACTION_TIME"
    "METRIC_TOTAL_MEDIA_COST_ADVERTISER"
    "METRIC_TOTAL_MEDIA_COST_ECPAPC_ADVERTISER"
    "METRIC_TOTAL_MEDIA_COST_ECPAPC_PARTNER"
    "METRIC_TOTAL_MEDIA_COST_ECPAPC_USD"
    "METRIC_TOTAL_MEDIA_COST_ECPAPV_ADVERTISER"
    "METRIC_TOTAL_MEDIA_COST_ECPAPV_PARTNER"
    "METRIC_TOTAL_MEDIA_COST_ECPAPV_USD"
    "METRIC_TOTAL_MEDIA_COST_ECPA_ADVERTISER"
    "METRIC_TOTAL_MEDIA_COST_ECPA_PARTNER"
    "METRIC_TOTAL_MEDIA_COST_ECPA_USD"
    "METRIC_TOTAL_MEDIA_COST_ECPCV_ADVERTISER"
    "METRIC_TOTAL_MEDIA_COST_ECPCV_PARTNER"
    "METRIC_TOTAL_MEDIA_COST_ECPCV_USD"
    "METRIC_TOTAL_MEDIA_COST_ECPC_ADVERTISER"
    "METRIC_TOTAL_MEDIA_COST_ECPC_PARTNER"
    "METRIC_TOTAL_MEDIA_COST_ECPC_USD"
    "METRIC_TOTAL_MEDIA_COST_ECPM_ADVERTISER"
    "METRIC_TOTAL_MEDIA_COST_ECPM_PARTNER"
    "METRIC_TOTAL_MEDIA_COST_ECPM_USD"
    "METRIC_TOTAL_MEDIA_COST_PARTNER"
    "METRIC_TOTAL_MEDIA_COST_USD"
    "METRIC_TOTAL_MEDIA_COST_VIEWABLE_ECPM_ADVERTISER"
    "METRIC_TOTAL_MEDIA_COST_VIEWABLE_ECPM_PARTNER"
    "METRIC_TOTAL_MEDIA_COST_VIEWABLE_ECPM_USD"
    "METRIC_TOTAL_PATHS"
    "METRIC_TOTAL_USERS"
    "METRIC_TRACKED_ADS"
    "METRIC_TRACKING_UNCONSENTED_CLICKS"
    "METRIC_TRUEVIEW_ALL_AD_SEQUENCE_IMPRESSIONS"
    "METRIC_TRUEVIEW_AVERAGE_CPE_ADVERTISER"
    "METRIC_TRUEVIEW_AVERAGE_CPE_PARTNER"
    "METRIC_TRUEVIEW_AVERAGE_CPE_USD"
    "METRIC_TRUEVIEW_CONVERSION_COST_MANY_PER_VIEW_ADVERTISER"
    "METRIC_TRUEVIEW_CONVERSION_COST_MANY_PER_VIEW_PARTNER"
    "METRIC_TRUEVIEW_CONVERSION_COST_MANY_PER_VIEW_USD"
    "METRIC_TRUEVIEW_CONVERSION_MANY_PER_VIEW"
    "METRIC_TRUEVIEW_CONVERSION_RATE_ONE_PER_VIEW"
    "METRIC_TRUEVIEW_CPV_ADVERTISER"
    "METRIC_TRUEVIEW_CPV_PARTNER"
    "METRIC_TRUEVIEW_CPV_USD"
    "METRIC_TRUEVIEW_EARNED_LIKES"
    "METRIC_TRUEVIEW_EARNED_PLAYLIST_ADDITIONS"
    "METRIC_TRUEVIEW_EARNED_SHARES"
    "METRIC_TRUEVIEW_EARNED_SUBSCRIBERS"
    "METRIC_TRUEVIEW_EARNED_VIEWS"
    "METRIC_TRUEVIEW_ENGAGEMENTS"
    "METRIC_TRUEVIEW_ENGAGEMENT_RATE"
    "METRIC_TRUEVIEW_GENERAL_INVALID_TRAFFIC_GIVT_VIEWS"
    "METRIC_TRUEVIEW_IMPRESSIONS_COVIEWED"
    "METRIC_TRUEVIEW_IMPRESSION_SHARE"
    "METRIC_TRUEVIEW_INVALID_VIEWS"
    "METRIC_TRUEVIEW_LOST_IS_BUDGET"
    "METRIC_TRUEVIEW_LOST_IS_RANK"
    "METRIC_TRUEVIEW_TOTAL_CONVERSION_VALUES_ADVERTISER"
    "METRIC_TRUEVIEW_TOTAL_CONVERSION_VALUES_PARTNER"
    "METRIC_TRUEVIEW_TOTAL_CONVERSION_VALUES_USD"
    "METRIC_TRUEVIEW_UNIQUE_VIEWERS"
    "METRIC_TRUEVIEW_VIEWS"
    "METRIC_TRUEVIEW_VIEW_RATE"
    "METRIC_TRUEVIEW_VIEW_THROUGH_CONVERSION"
    "METRIC_UNIQUE_REACH_AVERAGE_IMPRESSION_FREQUENCY"
    "METRIC_UNIQUE_REACH_AVERAGE_IMPRESSION_FREQUENCY_COVIEWED"
    "METRIC_UNIQUE_REACH_AVERAGE_VIEWABLE_IMPRESSION_FREQUENCY"
    "METRIC_UNIQUE_REACH_CLICK_REACH"
    "METRIC_UNIQUE_REACH_IMPRESSION_REACH"
    "METRIC_UNIQUE_REACH_IMPRESSION_REACH_ADDED_WITH_CROSS_STACK_FCAP"
    "METRIC_UNIQUE_REACH_IMPRESSION_REACH_ADDED_WITH_PG_FMGMT"
    "METRIC_UNIQUE_REACH_IMPRESSION_REACH_COVIEWED"
    "METRIC_UNIQUE_REACH_INCREMENTAL_CLICK_REACH"
    "METRIC_UNIQUE_REACH_INCREMENTAL_IMPRESSION_REACH"
    "METRIC_UNIQUE_REACH_INCREMENTAL_TOTAL_REACH"
    "METRIC_UNIQUE_REACH_INCREMENTAL_VIEWABLE_IMPRESSION_REACH"
    "METRIC_UNIQUE_REACH_TOTAL_REACH"
    "METRIC_UNIQUE_REACH_TOTAL_REACH_COVIEWED"
    "METRIC_UNIQUE_REACH_VIEWABLE_IMPRESSION_REACH"
    "METRIC_UNIQUE_VISITORS_COOKIES"
    "METRIC_VENDOR_BLOCKED_ADS"
    "METRIC_VERIFIABLE_IMPRESSIONS"
    "METRIC_VERIFICATION_VIDEO_PLAYER_SIZE_MEASURABLE_IMPRESSIONS"
    "METRIC_VIDEO_CLIENT_COST_ECPCV_ADVERTISER_CURRENCY"
    "METRIC_VIDEO_COMPANION_CLICKS"
    "METRIC_VIDEO_COMPANION_IMPRESSIONS"
    "METRIC_VIDEO_COMPLETION_RATE"
    "METRIC_VIEWABLE_BID_REQUESTS"
    "METRIC_VIEWABLE_GROSS_RATING_POINTS"
    "METRIC_VIRTUAL_PEOPLE_AVERAGE_IMPRESSION_FREQUENCY_BY_DEMO"
    "METRIC_VIRTUAL_PEOPLE_AVERAGE_IMPRESSION_FREQUENCY_BY_DEMO_COVIEWED"
    "METRIC_VIRTUAL_PEOPLE_AVERAGE_VIEWABLE_IMPRESSION_FREQUENCY_BY_DEMO"
    "METRIC_VIRTUAL_PEOPLE_CLICK_REACH_BY_DEMO"
    "METRIC_VIRTUAL_PEOPLE_DUPLICATE_CLICK_REACH"
    "METRIC_VIRTUAL_PEOPLE_DUPLICATE_CLICK_REACH_PERCENT"
    "METRIC_VIRTUAL_PEOPLE_DUPLICATE_IMPRESSION_REACH"
    "METRIC_VIRTUAL_PEOPLE_DUPLICATE_IMPRESSION_REACH_PERCENT"
    "METRIC_VIRTUAL_PEOPLE_DUPLICATE_TOTAL_REACH"
    "METRIC_VIRTUAL_PEOPLE_DUPLICATE_TOTAL_REACH_PERCENT"
    "METRIC_VIRTUAL_PEOPLE_DUPLICATE_VIEWABLE_IMPRESSION_REACH"
    "METRIC_VIRTUAL_PEOPLE_DUPLICATE_VIEWABLE_IMPRESSION_REACH_PERCENT"
    "METRIC_VIRTUAL_PEOPLE_EXCLUSIVE_CLICK_REACH"
    "METRIC_VIRTUAL_PEOPLE_EXCLUSIVE_CLICK_REACH_PERCENT"
    "METRIC_VIRTUAL_PEOPLE_EXCLUSIVE_IMPRESSION_REACH"
    "METRIC_VIRTUAL_PEOPLE_EXCLUSIVE_IMPRESSION_REACH_PERCENT"
    "METRIC_VIRTUAL_PEOPLE_EXCLUSIVE_TOTAL_REACH"
    "METRIC_VIRTUAL_PEOPLE_EXCLUSIVE_TOTAL_REACH_PERCENT"
    "METRIC_VIRTUAL_PEOPLE_EXCLUSIVE_VIEWABLE_IMPRESSION_REACH"
    "METRIC_VIRTUAL_PEOPLE_EXCLUSIVE_VIEWABLE_IMPRESSION_REACH_PERCENT"
    "METRIC_VIRTUAL_PEOPLE_IMPRESSION_REACH_BY_DEMO"
    "METRIC_VIRTUAL_PEOPLE_IMPRESSION_REACH_BY_DEMO_COVIEWED"
    "METRIC_VIRTUAL_PEOPLE_IMPRESSION_REACH_PERCENT"
    "METRIC_VIRTUAL_PEOPLE_IMPRESSION_REACH_PERCENT_COVIEWED"
    "METRIC_VIRTUAL_PEOPLE_IMPRESSION_REACH_SHARE_PERCENT"
    "METRIC_VIRTUAL_PEOPLE_IMPRESSION_REACH_SHARE_PERCENT_COVIEWED"
    "METRIC_VIRTUAL_PEOPLE_OVERLAP_CLICK_REACH"
    "METRIC_VIRTUAL_PEOPLE_OVERLAP_CLICK_REACH_PERCENT"
    "METRIC_VIRTUAL_PEOPLE_OVERLAP_IMPRESSION_REACH"
    "METRIC_VIRTUAL_PEOPLE_OVERLAP_IMPRESSION_REACH_PERCENT"
    "METRIC_VIRTUAL_PEOPLE_OVERLAP_TOTAL_REACH"
    "METRIC_VIRTUAL_PEOPLE_OVERLAP_TOTAL_REACH_PERCENT"
    "METRIC_VIRTUAL_PEOPLE_OVERLAP_VIEWABLE_IMPRESSION_REACH"
    "METRIC_VIRTUAL_PEOPLE_OVERLAP_VIEWABLE_IMPRESSION_REACH_PERCENT"
    "METRIC_VIRTUAL_PEOPLE_VIEWABLE_IMPRESSION_REACH_BY_DEMO"
    "METRIC_VIRTUAL_PEOPLE_VIEWABLE_IMPRESSION_REACH_PERCENT"
    "METRIC_VIRTUAL_PEOPLE_VIEWABLE_IMPRESSION_REACH_SHARE_PERCENT"
    "METRIC_WATCH_TIME"
    "METRIC_WIN_LOSS_DEAL_AVAILABLE_REQUESTS"
    "METRIC_WIN_LOSS_DEAL_TARGETED_IMPRESSIONS"
    "METRIC_WIN_LOSS_LINEITEM_AVAILABLE_REQUESTS"
    "METRIC_WIN_LOSS_LINEITEM_TARGETED_IMPRESSIONS"
    "METRIC_WIN_LOSS_RATE"})

(s/def ::metrics
  (s/coll-of ::metric :into [] :distinct true))

(s/def ::options ::options/spec)

(s/def ::spec
  (spec/only-keys :req-un [::type
                           ::group-bys
                           ::filters
                           ::metrics]
                  :opt-un [::options]))
