(ns com.adgoji.queries.core
  (:require
   [com.adgoji.doubleclick-spec.interface :as doubleclick-spec]
   [com.adgoji.java-utils.interface :as java-utils]
   [com.adgoji.sdk-client-utils.interface :as sdk-client-utils]
   [com.adgoji.spec.interface :as spec])
  (:import
   (com.google.api.services.doubleclickbidmanager DoubleClickBidManager DoubleClickBidManager$Queries$List)
   (com.google.api.services.doubleclickbidmanager.model Query RunQueryRequest)))

(defn create
  [^DoubleClickBidManager client query]
  (let [query-conformed (spec/check query ::doubleclick-spec/query)
        query-request   (java-utils/clj->java Query query-conformed)]
    (-> client
        (.queries)
        (.create query-request)
        (sdk-client-utils/execute-and-convert)
        (spec/check ::doubleclick-spec/query))))

(defn get-by-id
  [^DoubleClickBidManager client ^long query-id]
  (-> client
      (.queries)
      (.get query-id)
      (sdk-client-utils/execute-and-convert)
      (spec/check ::doubleclick-spec/query)))

(defn- fetch-queries-page
  [^DoubleClickBidManager$Queries$List request ^String next-page-token]
  (-> request
      (.setPageToken next-page-token)
      (sdk-client-utils/execute-and-convert)))

(defn get-list
  [^DoubleClickBidManager client {:keys [order-by limit]}]
  (let [request (-> client
                    (.queries)
                    (.list))]
    (when order-by
      (.setOrderBy ^DoubleClickBidManager$Queries$List request order-by))
    (-> (sdk-client-utils/execute-and-convert-paginated
         (partial fetch-queries-page request)
         :queries
         limit)
        (spec/check ::doubleclick-spec/queries))))

(defn delete
  [^DoubleClickBidManager client ^long query-id]
  (-> client
      (.queries)
      (.delete query-id)
      (sdk-client-utils/execute-and-convert)))

(defn run
  [^DoubleClickBidManager client
   ^long query-id
   run-query-request
   ^Boolean synchronous]
  (let [run-query-request-conformed
        (spec/check run-query-request ::doubleclick-spec/run-query-request)

        request-body
        (java-utils/clj->java RunQueryRequest
                              run-query-request-conformed)]
    (-> client
        (.queries)
        (.run query-id request-body)
        (.setSynchronous synchronous)
        (sdk-client-utils/execute-and-convert)
        (spec/check ::doubleclick-spec/report))))
