(ns com.adgoji.sdk-client-utils.interface
  (:require
   [com.adgoji.sdk-client-utils.core :as sdk-client-utils.core])
  (:import
   (com.google.api.client.googleapis.services AbstractGoogleClientRequest)))

(defn execute-and-convert
  "Execute Google API request and convert response to clojure data."
  [^AbstractGoogleClientRequest request]
  (sdk-client-utils.core/execute-and-convert request))

(defn execute-and-convert-paginated
  "Execute Google API request and convert response to clojure data.

  If `next-page-token` in the response is not empty, fetch next page
  using this token until all pages are consumed. Returns only `limit`
  number of entries."
  [fetch-page-fn vkey limit]
  (sdk-client-utils.core/execute-and-convert-paginated fetch-page-fn
                                                       vkey
                                                       limit))

(defn normalize-mask
  "Returns update mask string in format supported by Google.

  Input should be a sequence of keywords."
  [mask]
  (sdk-client-utils.core/normalize-mask mask))
