(ns com.adgoji.reports.core
  (:require
   [com.adgoji.doubleclick-spec.interface :as doubleclick-spec]
   [com.adgoji.sdk-client-utils.interface :as sdk-client-utils]
   [com.adgoji.spec.interface :as spec])
  (:import
   (com.google.api.services.doubleclickbidmanager DoubleClickBidManager DoubleClickBidManager$Queries$Reports$List)))

(defn get-by-id
  [^DoubleClickBidManager client query-id report-id]
  (-> client
      (.queries)
      (.reports)
      (.get (long query-id) (long report-id))
      (sdk-client-utils/execute-and-convert)
      (spec/check ::doubleclick-spec/report)))

(defn- fetch-reports-page
  [^DoubleClickBidManager$Queries$Reports$List request ^String next-page-token]
  (-> request
      (.setPageToken next-page-token)
      (sdk-client-utils/execute-and-convert)))

(defn get-list
  [^DoubleClickBidManager client query-id {:keys [order-by limit]}]
  (let [request (-> client
                    (.queries)
                    (.reports)
                    (.list (long query-id)))]
    (when order-by
      (.setOrderBy ^DoubleClickBidManager$Queries$Reports$List request order-by))
    (-> (sdk-client-utils/execute-and-convert-paginated
         (partial fetch-reports-page request)
         :reports
         limit)
        (spec/check ::doubleclick-spec/reports))))
