(ns com.adgoji.inventory-sources.core
  (:import
   (com.google.api.services.displayvideo.v4 DisplayVideo DisplayVideo$InventorySources$List))
  (:require
   [com.adgoji.spec.interface :as spec]
   [com.adgoji.displayvideo-spec.interface :as displayvideo-spec]
   [com.adgoji.sdk-client-utils.interface :as sdk-client-utils]))

(defn get-by-id
  [^DisplayVideo client
   inventory-source-id
   {:keys [advertiser-id partner-id] :as accessor-map}]
  (cond
    (and advertiser-id partner-id)
    (throw (ex-info "Only 1 accessor is allowed" {:accessor accessor-map}))

    (and (not advertiser-id) (not partner-id))
    (throw (ex-info "Missing accessor" {}))

    :else
    (let [request (cond-> (-> client
                              (.inventorySources)
                              (.get (long inventory-source-id)))
                    advertiser-id (.setAdvertiserId advertiser-id)
                    partner-id    (.setPartnerId partner-id))]
      (-> request
          (sdk-client-utils/execute-and-convert)
          (spec/check ::displayvideo-spec/inventory-source)))))

(defn- fetch-inventory-sources-page
  [^DisplayVideo$InventorySources$List request ^String next-page-token]
  (-> request
      (.setPageToken next-page-token)
      (sdk-client-utils/execute-and-convert)))

(defn get-list
  [^DisplayVideo client
   {:keys [advertiser-id partner-id] :as accessor-map}
   {:keys [order-by limit filter-expr]}]
  (cond
    (and advertiser-id partner-id)
    (throw (ex-info "Only 1 accessor is allowed" {:accessor accessor-map}))

    (and (not advertiser-id) (not partner-id))
    (throw (ex-info "Missing accessor" {}))

    :else
    (let [request  (cond-> (.list (.inventorySources client))
                     advertiser-id (.setAdvertiserId advertiser-id)
                     partner-id    (.setPartnerId partner-id)
                     order-by      (.setOrderBy order-by)
                     filter-expr   (.setFilter filter-expr))
          fetch-fn (partial fetch-inventory-sources-page request)]
      (-> (sdk-client-utils/execute-and-convert-paginated fetch-fn
                                                          :inventory-sources
                                                          limit)
          (spec/check ::displayvideo-spec/inventory-sources)))))
