(ns com.adgoji.displayvideo-spec.displayvideo.campaign
  (:require
   [clojure.spec.alpha :as s]
   [com.adgoji.spec.interface :as spec]
   [com.adgoji.displayvideo-spec.displayvideo.campaign.goal :as campaign.goal]
   [com.adgoji.displayvideo-spec.displayvideo.campaign.flight :as campaign.flight]
   [com.adgoji.displayvideo-spec.displayvideo.campaign.budget :as campaign.budget]
   [com.adgoji.displayvideo-spec.displayvideo.frequency-cap :as frequency-cap]
   [com.adgoji.displayvideo-spec.displayvideo.advertiser :as advertiser]))

(s/def ::name string?)
(s/def ::campaign-id int?)
(s/def ::display-name string?)
(s/def ::entity-status
  #{"ENTITY_STATUS_UNSPECIFIED"
    "ENTITY_STATUS_ACTIVE"
    "ENTITY_STATUS_ARCHIVED"
    "ENTITY_STATUS_PAUSED"
    "ENTITY_STATUS_DRAFT"
    "ENTITY_STATUS_SCHEDULED_FOR_DELETION"})
(s/def ::update-time string?)
(s/def ::campaign-goal
  (spec/only-keys :req-un [::campaign.goal/campaign-goal-type
                           ::campaign.goal/performance-goal]))

(s/def ::campaign-flight
  (spec/only-keys :req-un [::campaign.flight/planned-dates]
                  :opt-un [::campaign.flight/planned-spend-amount-micros]))

(s/def ::campaign-budget
  (spec/only-keys :req-un [::campaign.budget/display-name
                           ::campaign.budget/budget-unit
                           ::campaign.budget/budget-amount-micros
                           ::campaign.budget/date-range
                           ::campaign.budget/external-budget-source]
                  :opt-un [::campaign.budget/budget-id
                           ::campaign.budget/external-budget-id
                           ::campaign.budget/invoice-grouping-id
                           ::campaign.budget/prisma-config]))

(s/def ::campaign-budgets
  (s/coll-of ::campaign-budget :into []))

(s/def ::frequency-cap ::frequency-cap/spec)

(s/def ::spec
  (spec/only-keys :req-un [::display-name
                           ::entity-status
                           ::campaign-goal
                           ::campaign-flight
                           ::frequency-cap]
                  :opt-un [::name
                           ::advertiser/advertiser-id
                           ::campaign-id
                           ::update-time
                           ::campaign-budgets]))

(s/def ::update-spec
  (spec/only-keys :opt-un [::display-name
                           ::entity-status
                           ::campaign-goal
                           ::campaign-flight
                           ::frequency-cap
                           ::name
                           ::advertiser/advertiser-id
                           ::campaign-id
                           ::update-time
                           ::campaign-budgets]))
