(ns com.adgoji.displayvideo-spec.displayvideo.advertiser.location-list
  (:require
   [clojure.spec.alpha :as s]
   [com.adgoji.spec.interface :as spec]
   [com.adgoji.displayvideo-spec.displayvideo.targeting-location-type :as targeting-location-type]
   [com.adgoji.displayvideo-spec.displayvideo.advertiser :as advertiser]))

(s/def ::name string?)
(s/def ::location-list-id int?)
(s/def ::display-name string?)

(s/def ::spec
  (spec/only-keys :req-un [::display-name
                           ::targeting-location-type/location-type]
                  :opt-un [::advertiser/advertiser-id
                           ::name
                           ::location-list-id]))

(s/def ::update-spec
  (spec/only-keys :opt-un [::display-name
                           ::targeting-location-type/location-type
                           ::advertiser/advertiser-id
                           ::name
                           ::location-list-id]))
