(ns com.adgoji.displayvideo-api.advertisers.assets
  (:require
   [clojure.spec.alpha :as s]
   [com.adgoji.assets.interface :as assets]
   [com.adgoji.displayvideo-spec.interface :as displayvideo-spec]))

(defn upload
  "Returns the map which represents newly uploaded asset if successful.

  The asset file size should be no more than 10 MB for images, 200 MB
  for ZIP files, and 1 GB for videos."
  [client advertiser-id asset]
  (assets/upload client advertiser-id asset))

(s/fdef upload
  :args (s/cat :client ::displayvideo-spec/displayvideo-client
               :advertiser-id ::displayvideo-spec/advertiser-id
               :asset ::displayvideo-spec/create-asset-request)
  :ret ::displayvideo-spec/create-asset-response)
