(ns com.adgoji.displayvideo-spec.displayvideo.oba-icon
  (:require
   [clojure.spec.alpha :as s]
   [com.adgoji.spec.interface :as spec]
   [com.adgoji.displayvideo-spec.displayvideo.dimensions :as dimensions]))

(s/def ::resource-url string?)
(s/def ::resource-mime-type string?)
(s/def ::position
  #{"OBA_ICON_POSITION_UNSPECIFIED"
    "OBA_ICON_POSITION_UPPER_RIGHT"
    "OBA_ICON_POSITION_UPPER_LEFT"
    "OBA_ICON_POSITION_LOWER_RIGHT"
    "OBA_ICON_POSITION_LOWER_LEFT"})
(s/def ::dimensions
  (spec/only-keys :req-un [::dimensions/width-pixels
                           ::dimensions/height-pixels]))
(s/def ::program string?)
(s/def ::landing-page-url string?)
(s/def ::click-tracking-url string?)
(s/def ::view-tracking-url string?)
