(ns com.adgoji.displayvideo-spec.displayvideo.audience-group-assigned-targeting-option-details
  (:require
   [clojure.spec.alpha :as s]
   [com.adgoji.displayvideo-spec.displayvideo.combined-audience-targeting-setting
    :as combined-audience-targeting-setting]
   [com.adgoji.displayvideo-spec.displayvideo.custom-list-targeting-setting
    :as custom-list-targeting-setting]
   [com.adgoji.displayvideo-spec.displayvideo.first-party-and-partner-audience-group
    :as first-party-and-partner-audience-group]
   [com.adgoji.displayvideo-spec.displayvideo.google-audience-targeting-setting
    :as
    google-audience-targeting-setting]))

(s/def ::included-google-audience-group
  (s/keys :req-un [::google-audience-targeting-setting/settings]))

(s/def ::included-custom-list-group
  (s/keys :req-un [::custom-list-targeting-setting/settings]))

(s/def ::included-combined-audience-group
  (s/keys :req-un [::combined-audience-targeting-setting/settings]))

(s/def ::excluded-google-audience-group
  (s/keys :req-un [::google-audience-targeting-setting/settings]))

(s/def ::included-first-party-and-partner-audience-groups
  (s/coll-of ::first-party-and-partner-audience-group/spec
             :into []))

(s/def ::excluded-first-party-and-partner-audience-group
  ::first-party-and-partner-audience-group/spec)

(s/def ::spec
  (s/keys :opt-un [::included-google-audience-group
                   ::included-custom-list-group
                   ::included-combined-audience-group
                   ::excluded-google-audience-group
                   ::included-first-party-and-partner-audience-groups
                   ::excluded-first-party-and-partner-audience-group]))
