(ns com.adgoji.displayvideo-api.targeting-types-targeting-options
  (:require
   [clojure.spec.alpha :as s]
   [com.adgoji.displayvideo-spec.interface :as displayvideo-spec]
   [com.adgoji.targeting-types-targeting-options.interface
    :as
    targeting-options]))

(defn get-list
  "Returns a list of targeting options of a given type."
  [client targeting-type advertiser-id opts]
  (targeting-options/get-list client
                              targeting-type
                              advertiser-id
                              opts))

(s/fdef get-list
  :args (s/cat :client ::displayvideo-spec/displayvideo-client
               :targeting-type ::displayvideo-spec/targeting-type
               :advertiser-id ::displayvideo-spec/advertiser-id
               :opts (s/keys :opt-un [::displayvideo-spec/order-by
                                      ::displayvideo-spec/filter-expr
                                      ::displayvideo-spec/limit]))
  :ret ::displayvideo-spec/targeting-options)

(defn get-by-id
  "Returns a single targeting option by `targeting-option-id`."
  [client targeting-type targeting-option-id advertiser-id]
  (targeting-options/get-by-id client
                               targeting-type
                               targeting-option-id
                               advertiser-id))

(s/fdef get-by-id
  :args (s/cat :client ::displayvideo-spec/displayvideo-client
               :targeting-type ::displayvideo-spec/targeting-type
               :targeting-option-id ::displayvideo-spec/assigned-targeting-option-id
               :advertiser-id ::displayvideo-spec/advertiser-id)
  :ret ::displayvideo-spec/targeting-option)

(defn search
  "Searches for targeting options of a given type based on the given search
  terms."
  [client targeting-type search-targeting-option-request opts]
  (targeting-options/search client
                            targeting-type
                            search-targeting-option-request
                            opts))

(s/fdef search
  :args (s/cat :client ::displayvideo-spec/displayvideo-client
               :targeting-type ::displayvideo-spec/search-targeting-type
               :search-targeting-option-request ::displayvideo-spec/search-targeting-option-request
               :opts (s/keys :opt-un [::displayvideo-spec/limit]))
  :ret ::displayvideo-spec/targeting-options)
