(ns com.adgoji.partners-channels-sites.core
  (:require
   [com.adgoji.displayvideo-spec.interface :as displayvideo]
   [com.adgoji.java-utils.interface :as java-utils]
   [com.adgoji.sdk-client-utils.interface :as sdk-client-utils]
   [com.adgoji.spec.interface :as spec])
  (:import
   (com.google.api.services.displayvideo.v4 DisplayVideo DisplayVideo$Partners$Channels$Sites$List)
   (com.google.api.services.displayvideo.v4.model Site BulkEditSitesRequest ReplaceSitesRequest)))

(defn- fetch-channels-sites-page
  [^DisplayVideo$Partners$Channels$Sites$List request ^String next-page-token]
  (-> request
      (.setPageToken next-page-token)
      (sdk-client-utils/execute-and-convert)))

(defn create
  [^DisplayVideo client partner-id channel-id site]
  (let [site-conformed (spec/check site ::displayvideo/site)
        site-request   (java-utils/clj->java Site site-conformed)]
    (-> client
        (.partners)
        (.channels)
        (.sites)
        (.create (long partner-id) (long channel-id) site-request)
        (sdk-client-utils/execute-and-convert)
        (spec/check ::displayvideo/site))))

(defn get-list
  [^DisplayVideo client
   partner-id
   channel-id
   {:keys [order-by filter-expr limit]}]
  (let [request (-> client
                    (.partners)
                    (.channels)
                    (.sites)
                    (.list (long partner-id) (long channel-id)))]
    (when order-by
      (.setOrderBy ^DisplayVideo$Partners$Channels$Sites$List request order-by))
    (when filter-expr
      (.setFilter ^DisplayVideo$Partners$Channels$Sites$List request filter-expr))
    (-> (sdk-client-utils/execute-and-convert-paginated
         (partial fetch-channels-sites-page request)
         :sites
         limit)
        (spec/check ::displayvideo/sites))))

(defn bulk-edit
  [^DisplayVideo client partner-id channel-id bulk-edit-request]
  (let [bulk-edit-sites-conformed
        (spec/check bulk-edit-request ::displayvideo/bulk-edit-sites-request)

        bulk-edit-sites-request
        (java-utils/clj->java BulkEditSitesRequest bulk-edit-sites-conformed)]
    (-> client
        (.partners)
        (.channels)
        (.sites)
        (.bulkEdit (long partner-id) (long channel-id) bulk-edit-sites-request)
        (sdk-client-utils/execute-and-convert)
        :sites
        (spec/check ::displayvideo/sites))))

(defn delete
  [^DisplayVideo client partner-id channel-id url-or-app-id]
  (-> client
      (.partners)
      (.channels)
      (.sites)
      (.delete (long partner-id) (long channel-id) url-or-app-id)
      (sdk-client-utils/execute-and-convert)))

(defn replace-sites
  [^DisplayVideo client partner-id channel-id replace-sites]
  (let [replace-sites-conformed
        (spec/check replace-sites ::displayvideo/replace-sites-request)

        replace-sites-request
        (java-utils/clj->java ReplaceSitesRequest replace-sites-conformed)]
    (-> client
        (.partners)
        (.channels)
        (.sites)
        (.replace (long partner-id) (long channel-id) replace-sites-request)
        (sdk-client-utils/execute-and-convert)
        :sites
        (spec/check ::displayvideo/sites))))
