(ns com.adgoji.insertion-orders.core
  (:require
   [com.adgoji.displayvideo-spec.interface :as displayvideo-spec]
   [com.adgoji.java-utils.interface :as java-utils]
   [com.adgoji.sdk-client-utils.interface :as sdk-client-utils]
   [com.adgoji.spec.interface :as spec])
  (:import
   (com.google.api.services.displayvideo.v4 DisplayVideo DisplayVideo$Advertisers$InsertionOrders$List)
   (com.google.api.services.displayvideo.v4.model InsertionOrder)))

(defn create
  [^DisplayVideo client advertiser-id insertion-order]
  (let [insertion-order-conformed
        (spec/check insertion-order ::displayvideo-spec/insertion-order)

        insertion-order-request
        (java-utils/clj->java InsertionOrder
                              insertion-order-conformed)]
    (-> client
        (.advertisers)
        (.insertionOrders)
        (.create (long advertiser-id) insertion-order-request)
        (sdk-client-utils/execute-and-convert)
        (spec/check ::displayvideo-spec/insertion-order))))

(defn delete
  [^DisplayVideo client advertiser-id insertion-order-id]
  (-> client
      (.advertisers)
      (.insertionOrders)
      (.delete (long advertiser-id) (long insertion-order-id))
      (sdk-client-utils/execute-and-convert)))

(defn- fetch-insertion-orders-page
  [^DisplayVideo$Advertisers$InsertionOrders$List request
   ^String next-page-token]
  (-> request
      (.setPageToken next-page-token)
      (sdk-client-utils/execute-and-convert)))

(defn get-by-id
  [^DisplayVideo client advertiser-id insertion-order-id]
  (-> client
      (.advertisers)
      (.insertionOrders)
      (.get (long advertiser-id) (long insertion-order-id))
      (sdk-client-utils/execute-and-convert)
      (spec/check ::displayvideo-spec/insertion-order)))

(defn get-list
  [^DisplayVideo client advertiser-id {:keys [order-by filter-expr limit]}]
  (let [request (-> client
                    (.advertisers)
                    (.insertionOrders)
                    (.list (long advertiser-id)))]
    (when order-by
      (.setOrderBy ^DisplayVideo$Advertisers$InsertionOrders$List request order-by))
    (when filter-expr
      (.setFilter ^DisplayVideo$Advertisers$InsertionOrders$List request filter-expr))
    (-> (sdk-client-utils/execute-and-convert-paginated
         (partial fetch-insertion-orders-page request)
         :insertion-orders
         limit)
        (spec/check ::displayvideo-spec/insertion-orders))))

(defn update-by-id
  [^DisplayVideo client
   advertiser-id
   insertion-order-id
   insertion-order
   update-mask]
  (let [mask                    (-> update-mask
                                    (spec/check ::displayvideo-spec/update-mask)
                                    sdk-client-utils/normalize-mask)
        insertion-order-request (java-utils/clj->java InsertionOrder insertion-order)]
    (-> client
        (.advertisers)
        (.insertionOrders)
        (.patch (long advertiser-id)
                (long insertion-order-id)
                insertion-order-request)
        (.setUpdateMask mask)
        (sdk-client-utils/execute-and-convert)
        (spec/check ::displayvideo-spec/insertion-order))))
