(ns com.adgoji.displayvideo-spec.displayvideo.youtube-and-partners-settings
  (:require
   [clojure.spec.alpha :as s]
   [com.adgoji.displayvideo-spec.displayvideo.frequency-cap
    :as frequency-cap]
   [com.adgoji.displayvideo-spec.displayvideo.target-frequency
    :as target-frequency]
   [com.adgoji.displayvideo-spec.displayvideo.third-party-measurement-configs
    :as third-party-measurement-configs]
   [com.adgoji.displayvideo-spec.displayvideo.video-ad-sequence-settings
    :as video-ad-sequence-settings]
   [com.adgoji.displayvideo-spec.displayvideo.youtube-and-partners-inventory-source-config
    :as
    youtube-and-partners-inventory-source-config]))

(s/def ::view-frequency-cap ::frequency-cap/spec)
(s/def ::third-party-measurement-configs ::third-party-measurement-configs/spec)
(s/def ::inventory-source-settings ::youtube-and-partners-inventory-source-config/spec)
(s/def ::content-category
  #{"YOUTUBE_AND_PARTNERS_CONTENT_CATEGORY_UNSPECIFIED"
    "YOUTUBE_AND_PARTNERS_CONTENT_CATEGORY_STANDARD"
    "YOUTUBE_AND_PARTNERS_CONTENT_CATEGORY_EXPANDED"
    "YOUTUBE_AND_PARTNERS_CONTENT_CATEGORY_LIMITED"})
(s/def ::effective-content-category ::content-category)
(s/def ::target-frequency ::target-frequency/spec)
(s/def ::linked-merchant-id int?)
(s/def ::related-video-ids (s/coll-of int? :distinct true :into []))
(s/def ::lead-form-id int?)
(s/def ::video-ad-sequence-settings ::video-ad-sequence-settings/spec)
(s/def ::spec
  (s/keys :opt-un [::view-frequency-cap
                   ::third-party-measurement-configs
                   ::inventory-source-settings
                   ::content-category
                   ::effective-content-category
                   ::target-frequency
                   ::linked-merchant-id
                   ::related-video-ids
                   ::lead-form-id
                   ::video-ad-sequence-settings]))
