(ns com.adgoji.displayvideo-spec.displayvideo.kpi
  (:require
   [clojure.spec.alpha :as s]
   [com.adgoji.spec.interface :as spec]))

(s/def ::kpi-type
  #{"KPI_TYPE_UNSPECIFIED"
    "KPI_TYPE_CPM"
    "KPI_TYPE_CPC"
    "KPI_TYPE_CPA"
    "KPI_TYPE_CTR"
    "KPI_TYPE_VIEWABILITY"
    "KPI_TYPE_CPIAVC"
    "KPI_TYPE_CPE"
    "KPI_TYPE_CPV"
    "KPI_TYPE_CLICK_CVR"
    "KPI_TYPE_IMPRESSION_CVR"
    "KPI_TYPE_VCPM"
    "KPI_TYPE_VTR"
    "KPI_TYPE_AUDIO_COMPLETION_RATE"
    "KPI_TYPE_VIDEO_COMPLETION_RATE"
    "KPI_TYPE_CPCL"
    "KPI_TYPE_CPCV"
    "KPI_TYPE_TOS10"
    "KPI_TYPE_MAXIMIZE_PACING"
    "KPI_TYPE_CUSTOM_IMPRESSION_VALUE_OVER_COST"
    "KPI_TYPE_OTHER"})
(s/def ::kpi-algorithm-id spec/strict-long?)
(s/def ::kpi-amount-micros spec/strict-long?)
(s/def ::kpi-percentage-micros spec/strict-long?)
(s/def ::kpi-string string?)
(s/def ::spec
  (s/keys :req-un [::kpi-type]
          :opt-un [::kpi-algorithm-id
                   ::kpi-string
                   ::kpi-amount-micros
                   ::kpi-percentage-micros]))
