(ns com.adgoji.displayvideo-spec.displayvideo.insertion-order.budget
  (:require
   [clojure.spec.alpha :as s]
   [com.adgoji.displayvideo-spec.displayvideo.insertion-order.budget-segment
    :as
    insertion-order.budget-segment]))

(s/def ::budget-unit
  #{"BUDGET_UNIT_UNSPECIFIED"
    "BUDGET_UNIT_CURRENCY"
    "BUDGET_UNIT_IMPRESSIONS"})

(s/def ::automation-type
  #{"INSERTION_ORDER_AUTOMATION_TYPE_UNSPECIFIED"
    "INSERTION_ORDER_AUTOMATION_TYPE_BUDGET"
    "INSERTION_ORDER_AUTOMATION_TYPE_NONE"
    "INSERTION_ORDER_AUTOMATION_TYPE_BID_BUDGET"})

(s/def ::budget-segments
  (s/coll-of ::insertion-order.budget-segment/spec
             :into []))

(s/def ::spec
  (s/keys :req-un [::budget-unit ::budget-segments]
          :opt-un [::automation-type]))
