(ns com.adgoji.displayvideo-api.inventory-sources
  (:require
   [com.adgoji.inventory-sources.interface :as inventory-sources]
   [clojure.spec.alpha :as s]
   [com.adgoji.displayvideo-spec.interface :as displayvideo-spec]))

(defn get-by-id
  "Returns an inventory source by `inventory-source-id`."
  [client inventory-source-id accessor-map]
  (inventory-sources/get-by-id client inventory-source-id accessor-map))

(s/fdef get-by-id
  :args (s/cat :client ::displayvideo-spec/displayvideo-client
               :inventory-source-id ::displayvideo-spec/inventory-source-id
               :accessor-map ::displayvideo-spec/accessor)
  :ret ::displayvideo-spec/inventory-source)

(defn get-list
  "Returns a list of inventory sources."
  [client accessor-map opts]
  (inventory-sources/get-list client accessor-map opts))

(s/fdef get-list
  :args (s/cat :client ::displayvideo-spec/displayvideo-client
               :accessor-map ::displayvideo-spec/accessor
               :opts (s/keys :opt-un [::displayvideo-spec/order-by
                                      ::displayvideo-spec/filter-expr
                                      ::displayvideo-spec/limit]))
  :ret ::displayvideo-spec/inventory-sources)
