(ns com.adgoji.displayvideo-api.client
  (:require
   [com.adgoji.displayvideo-client.interface :as displayvideo-client]
   [com.adgoji.google-credential.interface :as google-credential])
  (:import
   (com.google.api.client.auth.oauth2 Credential)
   (com.google.api.services.displayvideo.v4 DisplayVideo DisplayVideoScopes)))

(def ^:private ->scope
  {:display-video                 DisplayVideoScopes/DISPLAY_VIDEO
   :doubleclickbidmanager         DisplayVideoScopes/DOUBLECLICKBIDMANAGER
   :display-video-mediaplanning   DisplayVideoScopes/DISPLAY_VIDEO_MEDIAPLANNING
   :display-video-user-management DisplayVideoScopes/DISPLAY_VIDEO_USER_MANAGEMENT})

(defn- convert-scopes
  [scopes]
  (if (coll? scopes)
    (let [scopes-xf
          (cond->> (filter (partial contains? (set (DisplayVideoScopes/all))))
            (every? keyword? scopes) (comp (map ->scope)))]
      (into #{} scopes-xf scopes))
    (if (and (keyword? scopes)
             (= :all ^clojure.lang.Keyword scopes))
      (set (DisplayVideoScopes/all))
      (throw (ex-info "Invalid scopes" {:scopes scopes})))))

(defn google-credential
  [opts]
  (google-credential/new (update opts :scopes convert-scopes)))

(defn new
  ^DisplayVideo
  [^Credential credential ^String application-name opts]
  (displayvideo-client/new credential application-name opts))
