(ns com.adgoji.displayvideo-spec.displayvideo.review-status-info
  (:require
   [clojure.spec.alpha :as s]
   [com.adgoji.displayvideo-spec.common :as spec.common]
   [com.adgoji.displayvideo-spec.displayvideo.exchange-review-status
    :as
    exchange-review-status]))

(s/def ::approval-status
  #{"APPROVAL_STATUS_UNSPECIFIED"
    "APPROVAL_STATUS_PENDING_NOT_SERVABLE"
    "APPROVAL_STATUS_PENDING_SERVABLE"
    "APPROVAL_STATUS_APPROVED_SERVABLE"
    "APPROVAL_STATUS_REJECTED_NOT_SERVABLE"})
(s/def ::creative-and-landing-page-review-status ::spec.common/review-status)
(s/def ::content-and-policy-review-status ::spec.common/review-status)
(s/def ::exchange-review-status
  (s/keys :req-un [::exchange-review-status/exchange
                   ::exchange-review-status/status]))
(s/def ::exchange-review-statuses
  (s/coll-of ::exchange-review-status :distinct true :into []))
(s/def ::spec
  (s/keys :req-un [::approval-status
                   ::creative-and-landing-page-review-status
                   ::exchange-review-statuses]
          :opt-un [::content-and-policy-review-status]))
