(ns com.adgoji.displayvideo-spec.displayvideo.partner-costs
  (:require
   [clojure.spec.alpha :as s]))

(s/def ::cost-type
  #{"PARTNER_COST_TYPE_UNSPECIFIED"
    "PARTNER_COST_TYPE_ADLOOX"
    "PARTNER_COST_TYPE_ADLOOX_PREBID"
    "PARTNER_COST_TYPE_ADSAFE"
    "PARTNER_COST_TYPE_ADXPOSE"
    "PARTNER_COST_TYPE_AGGREGATE_KNOWLEDGE"
    "PARTNER_COST_TYPE_AGENCY_TRADING_DESK"
    "PARTNER_COST_TYPE_DV360_FEE"
    "PARTNER_COST_TYPE_COMSCORE_VCE"
    "PARTNER_COST_TYPE_DATA_MANAGEMENT_PLATFORM"
    "PARTNER_COST_TYPE_DEFAULT"
    "PARTNER_COST_TYPE_DOUBLE_VERIFY"
    "PARTNER_COST_TYPE_DOUBLE_VERIFY_PREBID"
    "PARTNER_COST_TYPE_EVIDON"
    "PARTNER_COST_TYPE_INTEGRAL_AD_SCIENCE_VIDEO"
    "PARTNER_COST_TYPE_INTEGRAL_AD_SCIENCE_PREBID"
    "PARTNER_COST_TYPE_MEDIA_COST_DATA"
    "PARTNER_COST_TYPE_MOAT_VIDEO"
    "PARTNER_COST_TYPE_NIELSEN_DAR"
    "PARTNER_COST_TYPE_SHOP_LOCAL"
    "PARTNER_COST_TYPE_TERACENT"
    "PARTNER_COST_TYPE_THIRD_PARTY_AD_SERVER"
    "PARTNER_COST_TYPE_TRUST_METRICS"
    "PARTNER_COST_TYPE_VIZU"
    "PARTNER_COST_TYPE_ADLINGO_FEE"
    "PARTNER_COST_TYPE_CUSTOM_FEE_1"
    "PARTNER_COST_TYPE_CUSTOM_FEE_2"
    "PARTNER_COST_TYPE_CUSTOM_FEE_3"
    "PARTNER_COST_TYPE_CUSTOM_FEE_4"
    "PARTNER_COST_TYPE_CUSTOM_FEE_5"})

(s/def ::fee-type
  #{"PARTNER_COST_FEE_TYPE_UNSPECIFIED"
    "PARTNER_COST_FEE_TYPE_CPM_FEE"
    "PARTNER_COST_FEE_TYPE_MEDIA_FEE"})

(s/def ::invoice-type
  #{"PARTNER_COST_INVOICE_TYPE_UNSPECIFIED"
    "PARTNER_COST_INVOICE_TYPE_DV360"
    "PARTNER_COST_INVOICE_TYPE_PARTNER"})

(s/def ::fee-amount int?)
(s/def ::fee-percentage-millis int?)

(s/def ::spec
  (s/keys :req-un [::cost-type
                   ::fee-type
                   ::invoice-type]
          :opt-un [::fee-amount
                   ::fee-percentage-millis]))
