(ns com.adgoji.displayvideo-spec.displayvideo.line-item
  (:require
   [clojure.spec.alpha :as s]
   [com.adgoji.displayvideo-spec.displayvideo.advertiser :as advertiser]
   [com.adgoji.displayvideo-spec.displayvideo.bidding-strategy
    :as bidding-strategy]
   [com.adgoji.displayvideo-spec.displayvideo.campaign :as campaign]
   [com.adgoji.displayvideo-spec.displayvideo.conversion-counting-config
    :as conversion-counting-config]
   [com.adgoji.displayvideo-spec.displayvideo.creative :as creative]
   [com.adgoji.displayvideo-spec.displayvideo.frequency-cap
    :as frequency-cap]
   [com.adgoji.displayvideo-spec.displayvideo.insertion-order
    :as insertion-order]
   [com.adgoji.displayvideo-spec.displayvideo.integration-details
    :as integration-details]
   [com.adgoji.displayvideo-spec.displayvideo.line-item.budget
    :as line-item.budget]
   [com.adgoji.displayvideo-spec.displayvideo.line-item.flight
    :as line-item.flight]
   [com.adgoji.displayvideo-spec.displayvideo.mobile-app :as mobile-app]
   [com.adgoji.displayvideo-spec.displayvideo.pacing :as pacing]
   [com.adgoji.displayvideo-spec.displayvideo.partner-costs
    :as partner-costs]
   [com.adgoji.displayvideo-spec.displayvideo.partner-revenue-model
    :as partner-revenue-model]
   [com.adgoji.displayvideo-spec.displayvideo.targeting-expansion-config
    :as targeting-expansion-config]
   [com.adgoji.displayvideo-spec.displayvideo.youtube-and-partners-settings
    :as
    youtube-and-partners-settings]))

(s/def ::name string?)
(s/def ::line-item-id int?)
(s/def ::line-item-ids (s/coll-of ::line-item-id :distinct true :into []))
(s/def ::display-name string?)
(s/def ::update-time string?)
(s/def ::exclude-new-exchanges boolean?)

(s/def ::creative-ids
  (s/coll-of ::creative/creative-id :distinct true :into []))

(s/def ::message
  #{"LINE_ITEM_WARNING_MESSAGE_UNSPECIFIED"
    "INVALID_FLIGHT_DATES"
    "EXPIRED"
    "PENDING_FLIGHT"
    "ALL_PARTNER_ENABLED_EXCHANGES_NEGATIVELY_TARGETED"
    "INVALID_INVENTORY_SOURCE"
    "APP_INVENTORY_INVALID_SITE_TARGETING"
    "APP_INVENTORY_INVALID_AUDIENCE_LISTS"
    "NO_VALID_CREATIVE"
    "PARENT_INSERTION_ORDER_PAUSED"
    "PARENT_INSERTION_ORDER_EXPIRED"
    "DEPRECATED_FIRST_PARTY_AUDIENCE_EXCLUSION"})

(s/def ::warning-messages
  (s/coll-of ::message :distinct true :into []))

(s/def ::line-item-type
  #{"LINE_ITEM_TYPE_UNSPECIFIED"
    "LINE_ITEM_TYPE_DISPLAY_DEFAULT"
    "LINE_ITEM_TYPE_DISPLAY_MOBILE_APP_INSTALL"
    "LINE_ITEM_TYPE_VIDEO_DEFAULT"
    "LINE_ITEM_TYPE_VIDEO_MOBILE_APP_INSTALL"
    "LINE_ITEM_TYPE_DISPLAY_MOBILE_APP_INVENTORY"
    "LINE_ITEM_TYPE_VIDEO_MOBILE_APP_INVENTORY"
    "LINE_ITEM_TYPE_AUDIO_DEFAULT"
    "LINE_ITEM_TYPE_VIDEO_OVER_THE_TOP"
    "LINE_ITEM_TYPE_YOUTUBE_AND_PARTNERS_ACTION"
    "LINE_ITEM_TYPE_YOUTUBE_AND_PARTNERS_NON_SKIPPABLE"
    "LINE_ITEM_TYPE_YOUTUBE_AND_PARTNERS_VIDEO_SEQUENCE"
    "LINE_ITEM_TYPE_YOUTUBE_AND_PARTNERS_AUDIO"
    "LINE_ITEM_TYPE_YOUTUBE_AND_PARTNERS_REACH"
    "LINE_ITEM_TYPE_YOUTUBE_AND_PARTNERS_SIMPLE"
    "LINE_ITEM_TYPE_YOUTUBE_AND_PARTNERS_NON_SKIPPABLE_OVER_THE_TOP"
    "LINE_ITEM_TYPE_YOUTUBE_AND_PARTNERS_REACH_OVER_THE_TOP"
    "LINE_ITEM_TYPE_YOUTUBE_AND_PARTNERS_SIMPLE_OVER_THE_TOP"
    "LINE_ITEM_TYPE_YOUTUBE_AND_PARTNERS_TARGET_FREQUENCY"})

(s/def ::entity-status
  #{"ENTITY_STATUS_UNSPECIFIED"
    "ENTITY_STATUS_ACTIVE"
    "ENTITY_STATUS_ARCHIVED"
    "ENTITY_STATUS_DRAFT"
    "ENTITY_STATUS_PAUSED"
    "ENTITY_STATUS_SCHEDULED_FOR_DELETION"})

(s/def ::reservation-type
  #{"RESERVATION_TYPE_UNSPECIFIED"
    "RESERVATION_TYPE_NOT_GUARANTEED"
    "RESERVATION_TYPE_PROGRAMMATIC_GUARANTEED"
    "RESERVATION_TYPE_TAG_GUARANTEED"
    "RESERVATION_TYPE_PETRA_VIRAL"
    "RESERVATION_TYPE_INSTANT_RESERVE"})

(s/def ::bid-strategy ::bidding-strategy/spec)
(s/def ::budget ::line-item.budget/spec)
(s/def ::frequency-cap ::frequency-cap/spec)
(s/def ::mobile-app ::mobile-app/spec)
(s/def ::pacing ::pacing/spec)
(s/def ::partner-revenue-model ::partner-revenue-model/spec)
(s/def ::flight ::line-item.flight/spec)
(s/def ::conversion-counting ::conversion-counting-config/spec)
(s/def ::integration-details ::integration-details/spec)
(s/def ::partner-costs (s/coll-of ::partner-costs/spec :into []))
(s/def ::targeting-expansion ::targeting-expansion-config/spec)
(s/def ::youtube-and-partners-settings ::youtube-and-partners-settings/spec)
(s/def ::contains-eu-political-ads
  #{"EU_POLITICAL_ADVERTISING_STATUS_UNKNOWN"
    "CONTAINS_EU_POLITICAL_ADVERTISING"
    "DOES_NOT_CONTAIN_EU_POLITICAL_ADVERTISING"})

(s/def ::spec
  (s/keys :req-un [::bid-strategy
                   ::budget
                   ::display-name
                   ::entity-status
                   ::flight
                   ::frequency-cap
                   ::insertion-order/insertion-order-id
                   ::line-item-type
                   ::pacing
                   ::partner-revenue-model]
          :opt-un [::advertiser/advertiser-id
                   ::campaign/campaign-id
                   ::conversion-counting
                   ::creative-ids
                   ::exclude-new-exchanges
                   ::integration-details
                   ::line-item-id
                   ::mobile-app
                   ::name
                   ::partner-costs
                   ::reservation-type
                   ::targeting-expansion
                   ::update-time
                   ::warning-messages
                   ::youtube-and-partners-settings
                   ::contains-eu-political-ads]))

(s/def ::update-spec
  (s/keys :opt-un [::bid-strategy
                   ::budget
                   ::display-name
                   ::entity-status
                   ::flight
                   ::frequency-cap
                   ::insertion-order/insertion-order-id
                   ::line-item-type
                   ::pacing
                   ::partner-revenue-model
                   ::advertiser/advertiser-id
                   ::campaign/campaign-id
                   ::conversion-counting
                   ::creative-ids
                   ::exclude-new-exchanges
                   ::integration-details
                   ::line-item-id
                   ::mobile-app
                   ::name
                   ::partner-costs
                   ::reservation-type
                   ::targeting-expansion
                   ::update-time
                   ::warning-messages
                   ::youtube-and-partners-settings
                   ::contains-eu-political-ads]))
