(ns com.adgoji.displayvideo-spec.displayvideo.inventory-source
  (:require
   [clojure.spec.alpha :as s]
   [com.adgoji.displayvideo-spec.displayvideo.advertiser :as advertiser]
   [com.adgoji.displayvideo-spec.displayvideo.creative-config
    :as creative-config]
   [com.adgoji.displayvideo-spec.displayvideo.inventory-source.accessors
    :as inventory-source.accessors]
   [com.adgoji.displayvideo-spec.displayvideo.inventory-source.status
    :as inventory-source.status]
   [com.adgoji.displayvideo-spec.displayvideo.partner :as partner]
   [com.adgoji.displayvideo-spec.displayvideo.rate-details
    :as rate-details]
   [com.adgoji.displayvideo-spec.displayvideo.time-range :as time-range]))

(s/def ::name string?)
(s/def ::inventory-source-id int?)
(s/def ::display-name string?)
(s/def ::inventory-source-type
  #{"INVENTORY_SOURCE_TYPE_UNSPECIFIED"
    "INVENTORY_SOURCE_TYPE_PRIVATE"
    "INVENTORY_SOURCE_TYPE_AUCTION_PACKAGE"})
(s/def ::inventory-source-product-type
  #{"INVENTORY_SOURCE_PRODUCT_TYPE_UNSPECIFIED"
    "PREFERRED_DEAL"
    "PRIVATE_AUCTION"
    "PROGRAMMATIC_GUARANTEED"
    "TAG_GUARANTEED"
    "YOUTUBE_RESERVE"
    "INSTANT_RESERVE"
    "GUARANTEED_PACKAGE"
    "PROGRAMMATIC_TV"
    "AUCTION_PACKAGE"})
(s/def ::commitment
  #{"INVENTORY_SOURCE_COMMITMENT_UNSPECIFIED"
    "INVENTORY_SOURCE_COMMITMENT_GUARANTEED"
    "INVENTORY_SOURCE_COMMITMENT_NON_GUARANTEED"})
(s/def ::delivery-method
  #{"INVENTORY_SOURCE_DELIVERY_METHOD_UNSPECIFIED"
    "INVENTORY_SOURCE_DELIVERY_METHOD_PROGRAMMATIC"
    "INVENTORY_SOURCE_DELIVERY_METHOD_TAG"})
(s/def ::deal-id string?)
(s/def ::status ::inventory-source.status/spec)
(s/def ::exchange string?)
(s/def ::update-time string?)
(s/def ::rate-details ::rate-details/spec)
(s/def ::publisher-name string?)
(s/def ::time-range ::time-range/spec)
(s/def ::creative-configs
  (s/coll-of ::creative-config/spec :into []))
(s/def ::guaranteed-order-id string?)
(s/def ::read-write-accessors ::inventory-source.accessors/spec)
(s/def ::read-advertiser-ids
  (s/coll-of ::advertiser/advertiser-id :into []))
(s/def ::read-partner-ids
  (s/coll-of ::partner/partner-id :into []))
(s/def ::spec
  (s/keys :req-un [::display-name
                   ::inventory-source-type
                   ::deal-id
                   ::status
                   ::rate-details]
          :opt-un [::name
                   ::inventory-source-id
                   ::inventory-source-product-type
                   ::commitment
                   ::delivery-method
                   ::exchange
                   ::update-time
                   ::publisher-name
                   ::time-range
                   ::creative-configs
                   ::guaranteed-order-id
                   ::read-write-accessors
                   ::read-advertiser-ids
                   ::read-partner-ids]))
