(ns com.adgoji.displayvideo-spec.displayvideo.frequency-cap
  (:require
   [clojure.spec.alpha :as s]
   [com.adgoji.spec.interface :as spec]))

(s/def ::unlimited boolean?)
(s/def ::time-unit
  #{"TIME_UNIT_UNSPECIFIED"
    "TIME_UNIT_LIFETIME"
    "TIME_UNIT_MONTHS"
    "TIME_UNIT_WEEKS"
    "TIME_UNIT_DAYS"
    "TIME_UNIT_HOURS"
    "TIME_UNIT_MINUTES"})
(s/def ::time-unit-count int?)
(s/def ::max-impressions int?)
(s/def ::max-views int?)

(defmulti frequency-cap-spec (comp boolean :unlimited))

(defmethod frequency-cap-spec true
  [_]
  (spec/only-keys :opt-un [::unlimited]))

(defmethod frequency-cap-spec false
  [_]
  (spec/only-keys :req-un [::time-unit
                           ::time-unit-count]
                  :opt-un [::unlimited
                           ::max-impressions
                           ::max-views]))

(s/def ::spec (s/multi-spec frequency-cap-spec ::frequency-cap))
