(ns com.adgoji.displayvideo-spec.displayvideo.double-verify
  (:require
   [clojure.spec.alpha :as s]
   [com.adgoji.spec.interface :as spec]))

(s/def ::brand-safety-categories
  (spec/only-keys :opt-un [::avoid-unknown-brand-safety-category
                           ::avoided-high-severity-categories
                           ::avoided-medium-severity-categories]))

(s/def ::avoid-unknown-brand-safety-category boolean?)

(s/def ::high-severity-category
  #{"HIGHER_SEVERITY_UNSPECIFIED"
    "ADULT_CONTENT_PORNOGRAPHY"
    "COPYRIGHT_INFRINGEMENT"
    "SUBSTANCE_ABUSE"
    "GRAPHIC_VIOLENCE_WEAPONS"
    "HATE_PROFANITY"
    "CRIMINAL_SKILLS"
    "NUISANCE_INCENTIVIZED_MALWARE_CLUTTER"})

(s/def ::avoided-high-severity-categories
  (s/coll-of ::high-severity-category :into []))

(s/def ::medium-severity-category
  #{"MEDIUM_SEVERITY_UNSPECIFIED"
    "AD_SERVERS"
    "ADULT_CONTENT_SWIMSUIT"
    "ALTERNATIVE_LIFESTYLES"
    "CELEBRITY_GOSSIP"
    "GAMBLING"
    "OCCULT"
    "SEX_EDUCATION"
    "DISASTER_AVIATION"
    "DISASTER_MAN_MADE"
    "DISASTER_NATURAL"
    "DISASTER_TERRORIST_EVENTS"
    "DISASTER_VEHICLE"
    "ALCOHOL"
    "SMOKING"
    "NEGATIVE_NEWS_FINANCIAL"
    "NON_ENGLISH"
    "PARKING_PAGE"
    "UNMODERATED_UGC"
    "INFLAMMATORY_POLITICS_AND_NEWS"
    "NEGATIVE_NEWS_PHARMACEUTICAL"})

(s/def ::avoided-medium-severity-categories
  (s/coll-of ::medium-severity-category :into []))

(s/def ::age-rating
  #{"AGE_RATING_UNSPECIFIED"
    "APP_AGE_RATE_UNKNOWN"
    "APP_AGE_RATE_4_PLUS"
    "APP_AGE_RATE_9_PLUS"
    "APP_AGE_RATE_12_PLUS"
    "APP_AGE_RATE_17_PLUS"
    "APP_AGE_RATE_18_PLUS"})

(s/def ::avoided-age-ratings
  (s/coll-of ::age-rating :into []))

(s/def ::avoided-star-rating
  #{"APP_STAR_RATE_UNSPECIFIED"
    "APP_STAR_RATE_1_POINT_5_LESS"
    "APP_STAR_RATE_2_LESS"
    "APP_STAR_RATE_2_POINT_5_LESS"
    "APP_STAR_RATE_3_LESS"
    "APP_STAR_RATE_3_POINT_5_LESS"
    "APP_STAR_RATE_4_LESS"
    "APP_STAR_RATE_4_POINT_5_LESS"})

(s/def ::avoid-insufficient-star-rating boolean?)

(s/def ::app-star-rating
  (spec/only-keys :opt-un [::avoided-star-rating
                           ::avoid-insufficient-star-rating]))

(s/def ::iab
  #{"IAB_VIEWED_RATE_UNSPECIFIED"
    "IAB_VIEWED_RATE_80_PERCENT_HIGHER"
    "IAB_VIEWED_RATE_75_PERCENT_HIGHER"
    "IAB_VIEWED_RATE_70_PERCENT_HIGHER"
    "IAB_VIEWED_RATE_65_PERCENT_HIGHER"
    "IAB_VIEWED_RATE_60_PERCENT_HIGHER"
    "IAB_VIEWED_RATE_55_PERCENT_HIGHER"
    "IAB_VIEWED_RATE_50_PERCENT_HIGHER"
    "IAB_VIEWED_RATE_40_PERCENT_HIGHER"
    "IAB_VIEWED_RATE_30_PERCENT_HIGHER"})

(s/def ::viewable-during
  #{"AVERAGE_VIEW_DURATION_UNSPECIFIED"
    "AVERAGE_VIEW_DURATION_5_SEC"
    "AVERAGE_VIEW_DURATION_10_SEC"
    "AVERAGE_VIEW_DURATION_15_SEC"})

(s/def ::display-viewability
  (spec/only-keys :opt-un [::iab
                           ::viewable-during]))

(s/def ::video-iab
  #{"VIDEO_IAB_UNSPECIFIED"
    "IAB_VIEWABILITY_80_PERCENT_HIGHER"
    "IAB_VIEWABILITY_75_PERCENT_HIGHER"
    "IAB_VIEWABILITY_70_PERCENT_HIGHER"
    "IAB_VIEWABILITY_65_PERCENT_HIGHER"
    "IAB_VIEWABILITY_60_PERCENT_HIGHER"
    "IAB_VIEWABILITY_55_PERCENT_HIGHER"
    "IAB_VIEWABILITY_50_PERCENT_HIGHER"
    "IAB_VIEWABILITY_40_PERCENT_HIGHER"
    "IAB_VIEWABILITY_30_PERCENT_HIGHER"})

(s/def ::video-viewable-rate
  #{"VIDEO_VIEWABLE_RATE_UNSPECIFIED"
    "VIEWED_PERFORMANCE_40_PERCENT_HIGHER"
    "VIEWED_PERFORMANCE_35_PERCENT_HIGHER"
    "VIEWED_PERFORMANCE_30_PERCENT_HIGHER"
    "VIEWED_PERFORMANCE_25_PERCENT_HIGHER"
    "VIEWED_PERFORMANCE_20_PERCENT_HIGHER"
    "VIEWED_PERFORMANCE_10_PERCENT_HIGHER"})

(s/def ::player-impression-rate
  #{"PLAYER_SIZE_400X300_UNSPECIFIED"
    "PLAYER_SIZE_400X300_95"
    "PLAYER_SIZE_400X300_70"
    "PLAYER_SIZE_400X300_25"
    "PLAYER_SIZE_400X300_5"})

(s/def ::video-viewability
  (spec/only-keys :opt-un [::video-iab
                           ::video-viewable-rate
                           ::player-impression-rate]))

(s/def ::avoid-insufficient-option boolean?)

(s/def ::avoided-fraud-option
  #{"FRAUD_UNSPECIFIED"
    "AD_IMPRESSION_FRAUD_100"
    "AD_IMPRESSION_FRAUD_50"
    "AD_IMPRESSION_FRAUD_25"
    "AD_IMPRESSION_FRAUD_10"
    "AD_IMPRESSION_FRAUD_8"
    "AD_IMPRESSION_FRAUD_6"
    "AD_IMPRESSION_FRAUD_4"
    "AD_IMPRESSION_FRAUD_2"})

(s/def ::fraud-invalid-traffic
  (spec/only-keys :opt-un [::avoided-fraud-option
                           ::avoid-insufficient-option]))

(s/def ::custom-segment-id int?)
