(ns com.adgoji.displayvideo-spec.displayvideo.asset-association
  (:require
   [clojure.spec.alpha :as s]
   [com.adgoji.spec.interface :as spec]
   [com.adgoji.displayvideo-spec.displayvideo.asset :as asset]))

(s/def ::asset
  (spec/only-keys :req-un [::asset/media-id]
                  :opt-un [::asset/content]))

;; See
;; https://developers.google.com/display-video/api/reference/rest/v2/advertisers.creatives#AssetRole
;; for details
(s/def ::role
  #{"ASSET_ROLE_UNSPECIFIED"
    "ASSET_ROLE_MAIN"
    "ASSET_ROLE_BACKUP"
    "ASSET_ROLE_POLITE_LOAD"
    "ASSET_ROLE_HEADLINE"
    "ASSET_ROLE_LONG_HEADLINE"
    "ASSET_ROLE_BODY"
    "ASSET_ROLE_LONG_BODY"
    "ASSET_ROLE_CAPTION_URL"
    "ASSET_ROLE_CALL_TO_ACTION"
    "ASSET_ROLE_ADVERTISER_NAME"
    "ASSET_ROLE_PRICE"
    "ASSET_ROLE_ANDROID_APP_ID"
    "ASSET_ROLE_IOS_APP_ID"
    "ASSET_ROLE_RATING"
    "ASSET_ROLE_ICON"
    "ASSET_ROLE_COVER_IMAGE"})
