(ns com.adgoji.displayvideo-api.partners.sites
  (:require
   [clojure.spec.alpha :as s]
   [com.adgoji.displayvideo-spec.interface :as displayvideo-spec]
   [com.adgoji.partners-channels-sites.interface :as sites]))

(defn bulk-edit
  "Bulk edits sites under a single channel."
  [client partner-id channel-id bulk-edit-request]
  (sites/bulk-edit client partner-id channel-id bulk-edit-request))

(s/fdef bulk-edit
  :args (s/cat :client ::displayvideo-spec/displayvideo-client
               :partner-id ::displayvideo-spec/partner-id
               :channel-id ::displayvideo-spec/channel-id
               :bulk-edit-request ::displayvideo-spec/bulk-edit-sites-request)
  :ret ::displayvideo-spec/sites)

(defn create
  "Creates a site in a channel"
  [client partner-id channel-id site]
  (sites/create client partner-id channel-id site))

(s/fdef create
  :args (s/cat :client ::displayvideo-spec/displayvideo-client
               :partner-id ::displayvideo-spec/partner-id
               :channel-id ::displayvideo-spec/channel-id
               :site ::displayvideo-spec/site)
  :ret ::displayvideo-spec/site)

(defn replace-sites
  "Replaces all of the sites under a single channel."
  [client partner-id channel-id replace-sites]
  (sites/replace-sites client
                       partner-id
                       channel-id
                       replace-sites))

(s/fdef replace-sites
  :args (s/cat :client ::displayvideo-spec/displayvideo-client
               :partner-id ::displayvideo-spec/partner-id
               :channel-id ::displayvideo-spec/channel-id
               :replace-sites ::displayvideo-spec/replace-sites-request)
  :ret ::displayvideo-spec/sites)

(defn get-list
  "Lists sites in a channel."
  [client partner-id channel-id opts]
  (sites/get-list client partner-id channel-id opts))

(s/fdef get-list
  :args (s/cat :client ::displayvideo-spec/displayvideo-client
               :partner-id ::displayvideo-spec/partner-id
               :channel-id ::displayvideo-spec/channel-id
               :opts (s/keys :opt-un [::displayvideo-spec/order-by
                                      ::displayvideo-spec/filter-expr
                                      ::displayvideo-spec/limit]))
  :ret ::displayvideo-spec/sites)

(defn delete
  "Deletes a site from a channel."
  [client partner-id channel-id url-or-app-id]
  (sites/delete client partner-id channel-id url-or-app-id))

(s/fdef delete
  :args (s/cat :client ::displayvideo-spec/displayvideo-client
               :partner-id ::displayvideo-spec/partner-id
               :channel-id ::displayvideo-spec/channel-id
               :url-or-app-id ::displayvideo-spec/url-or-app-id)
  :ret (s/and map? empty?))