(ns com.adgoji.displayvideo-api.advertisers.campaigns
  (:require
   [clojure.spec.alpha :as s]
   [com.adgoji.campaigns.interface :as campaigns]
   [com.adgoji.displayvideo-spec.interface :as displayvideo-spec]))

(defn create
  "Create a new campaign."
  [client advertiser-id campaign]
  (campaigns/create client advertiser-id campaign))

(s/fdef create
  :args (s/cat :client ::displayvideo-spec/displayvideo-client
               :advertiser-id ::displayvideo-spec/advertiser-id
               :campaign ::displayvideo-spec/campaign)
  :ret ::displayvideo-spec/campaign)

(defn delete
  "Delete campaign by `advertiser-id` and `campaign-id`."
  [client advertiser-id campaign-id]
  (campaigns/delete client advertiser-id campaign-id))

(s/fdef delete
  :args (s/cat :client ::displayvideo-spec/displayvideo-client
               :advertiser-id ::displayvideo-spec/advertiser-id
               :campaign-id ::displayvideo-spec/campaign-id)
  :ret (s/and map? empty?))

(defn get-by-id
  "Get a single campaign by `advertiser-id` and `campaign-id`."
  [client advertiser-id campaign-id]
  (campaigns/get-by-id client advertiser-id campaign-id))

(s/fdef get-by-id
  :args (s/cat :client ::displayvideo-spec/displayvideo-client
               :advertiser-id ::displayvideo-spec/advertiser-id
               :campaign-id ::displayvideo-spec/campaign-id)
  :ret ::displayvideo-spec/campaign)

(defn get-list
  "Returns a list of all advertiser's campaigns."
  [client advertiser-id opts]
  (campaigns/get-list client advertiser-id opts))

(s/fdef get-list
  :args (s/cat :client ::displayvideo-spec/displayvideo-client
               :advertiser-id ::displayvideo-spec/advertiser-id
               :opts (s/keys :opt-un [::displayvideo-spec/order-by
                                      ::displayvideo-spec/filter-expr
                                      ::displayvideo-spec/limit]))
  :ret ::displayvideo-spec/campaigns)

(defn update-by-id
  "Update an existing campaign by `advertiser-id` and `campaign-id`.

  Request body is the same as for [[create]] function. Additionally
  `update-mask` is a mandatory parameter, it should be a sequence of
  fully qualified names of fields (as keywords)."
  [client advertiser-id campaign-id campaign update-mask]
  (campaigns/update-by-id client
                          advertiser-id
                          campaign-id
                          campaign
                          update-mask))

(s/fdef update-by-id
  :args (s/cat :client ::displayvideo-spec/displayvideo-client
               :advertiser-id ::displayvideo-spec/advertiser-id
               :campaign-id ::displayvideo-spec/campaign-id
               :campaign ::displayvideo-spec/campaign-update
               :update-mask ::displayvideo-spec/update-mask)
  :ret ::displayvideo-spec/campaign)
